<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? $_GET['action'] ?? '';

/* ===========================================================
    IMAGE UPLOAD FUNCTION
   =========================================================== */
function upload_image($input, $diskDir="../uploads/jobs", $publicPath="uploads/jobs")
{
    if (empty($_FILES[$input]['name'])) return null;

    if (!is_dir($diskDir)) mkdir($diskDir, 0775, true);

    $ext = strtolower(pathinfo($_FILES[$input]['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, ['jpg','jpeg','png','webp'])) return null;

    $filename = time() . "_" . preg_replace("/[^a-zA-Z0-9_\.-]/", "_", $_FILES[$input]['name']);
    $fullDisk = rtrim($diskDir, "/") . "/" . $filename;

    move_uploaded_file($_FILES[$input]['tmp_name'], $fullDisk);

    return rtrim($publicPath, "/") . "/" . $filename;
}

/* ===========================================================
    SAVE JOB (INSERT / UPDATE)
   =========================================================== */
if ($action === "save_job") {

    $id = (int)($_POST['id'] ?? 0);
    $title = $_POST['title'];
    $subtitle = $_POST['subtitle'];
    $email = $_POST['apply_email'];
    $deadline = $_POST['apply_deadline'];

    // old hero image
    $old = "";
    if ($id > 0) {
        $stm = $pdo->prepare("SELECT hero_image FROM iaos_jobs WHERE id=?");
        $stm->execute([$id]);
        $old = $stm->fetchColumn();
    }

    $newHero = upload_image("hero_image");

    if ($id == 0) {
        // INSERT
        $pdo->prepare("
            INSERT INTO iaos_jobs (title, subtitle, hero_image, apply_email, apply_deadline)
            VALUES (?, ?, ?, ?, ?)
        ")->execute([
            $title,
            $subtitle,
            $newHero ?: '',
            $email,
            $deadline
        ]);

        header("Location: admin_jobs.php?saved=1");
        exit;

    } else {
        // UPDATE
        $finalHero = $newHero ?: $old;

        $pdo->prepare("
            UPDATE iaos_jobs 
            SET title=?, subtitle=?, hero_image=?, apply_email=?, apply_deadline=? 
            WHERE id=?
        ")->execute([
            $title,
            $subtitle,
            $finalHero,
            $email,
            $deadline,
            $id
        ]);

        header("Location: admin_edit_job.php?id=$id&saved=1");
        exit;
    }
}

/* ===========================================================
    DELETE JOB + CHILDREN
   =========================================================== */
if ($action === "delete_job") {
    $id = (int)($_GET['id'] ?? 0);

    if ($id > 0) {
        $pdo->prepare("DELETE FROM iaos_jobs WHERE id=?")->execute([$id]);
    }

    header("Location: admin_jobs.php?saved=1");
    exit;
}

/* ===========================================================
    ADD HEADING
   =========================================================== */
if ($action === "add_heading") {
    $job_id = (int)$_POST['job_id'];
    $text = $_POST['heading_text'];

    $pdo->prepare("
        INSERT INTO iaos_job_headings (job_id, heading_text, position)
        VALUES (?, ?, ?)
    ")->execute([$job_id, $text, time()]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    DELETE HEADING (auto deletes paras)
   =========================================================== */
if ($action === "delete_heading") {
    $id = (int)$_POST['id'];

    // get job_id before deleting
    $job_id = $pdo->prepare("SELECT job_id FROM iaos_job_headings WHERE id=?");
    $job_id->execute([$id]);
    $job_id = $job_id->fetchColumn();

    $pdo->prepare("DELETE FROM iaos_job_headings WHERE id=?")->execute([$id]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    ADD PARAGRAPH
   =========================================================== */
if ($action === "add_paragraph") {

    $job_id = (int)$_POST['job_id'];
    $heading_id = (int)$_POST['heading_id'];
    $text = $_POST['para_text'];

    $pdo->prepare("
        INSERT INTO iaos_job_paragraphs (job_id, heading_id, para_text, position)
        VALUES (?, ?, ?, ?)
    ")->execute([$job_id, $heading_id, $text, time()]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    UPDATE PARAGRAPH
   =========================================================== */
if ($action === "update_paragraph") {

    $id = (int)$_POST['id'];
    $text = $_POST['para_text'];

    // get job_id
    $stm = $pdo->prepare("SELECT job_id FROM iaos_job_paragraphs WHERE id=?");
    $stm->execute([$id]);
    $job_id = $stm->fetchColumn();

    $pdo->prepare("UPDATE iaos_job_paragraphs SET para_text=? WHERE id=?")
        ->execute([$text, $id]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    DELETE PARAGRAPH
   =========================================================== */
if ($action === "delete_paragraph") {

    $id = (int)$_POST['id'];

    // get job_id
    $stm = $pdo->prepare("SELECT job_id FROM iaos_job_paragraphs WHERE id=?");
    $stm->execute([$id]);
    $job_id = $stm->fetchColumn();

    $pdo->prepare("DELETE FROM iaos_job_paragraphs WHERE id=?")->execute([$id]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    ADD REQUIREMENT
   =========================================================== */
if ($action === "add_requirement") {

    $job_id = (int)$_POST['job_id'];
    $text = $_POST['item_text'];

    $pdo->prepare("
        INSERT INTO iaos_job_requirements (job_id, item_text, position)
        VALUES (?, ?, ?)
    ")->execute([$job_id, $text, time()]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    UPDATE REQUIREMENT
   =========================================================== */
if ($action === "update_requirement") {

    $id = (int)$_POST['id'];
    $text = $_POST['item_text'];

    // get job
    $stm = $pdo->prepare("SELECT job_id FROM iaos_job_requirements WHERE id=?");
    $stm->execute([$id]);
    $job_id = $stm->fetchColumn();

    $pdo->prepare("UPDATE iaos_job_requirements SET item_text=? WHERE id=?")
        ->execute([$text, $id]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    DELETE REQUIREMENT
   =========================================================== */
if ($action === "delete_requirement") {

    $id = (int)$_POST['id'];

    // get job
    $stm = $pdo->prepare("SELECT job_id FROM iaos_job_requirements WHERE id=?");
    $stm->execute([$id]);
    $job_id = $stm->fetchColumn();

    $pdo->prepare("DELETE FROM iaos_job_requirements WHERE id=?")->execute([$id]);

    header("Location: admin_edit_job.php?id=$job_id&saved=1");
    exit;
}

/* ===========================================================
    DEFAULT
   =========================================================== */
header("Location: admin_jobs.php");
exit;
