<?php
ob_start();
session_start();
require_once "db.php"; // ✅ gives $pdo

function go($url){
  header("Location: ".$url);
  exit;
}

/* ✅ Safe delete old image file */
function deleteFileSafe($relativePath){
  if(empty($relativePath)) return;

  $relativePath = ltrim($relativePath, "/");

  // block path traversal
  if(strpos($relativePath, "..") !== false) return;

  $absPath = __DIR__ . "/../" . $relativePath;
  if(is_file($absPath)){
    @unlink($absPath);
  }
}

/* ✅ Upload campaign image (HD allowed) */
function uploadCampaignImage($fileKey){
  if(empty($_FILES[$fileKey]['name'])) return "";

  if(!isset($_FILES[$fileKey]['tmp_name']) || !is_uploaded_file($_FILES[$fileKey]['tmp_name'])){
    return "";
  }

  // ✅ allow big HD images (15MB)
  $maxSize = 15 * 1024 * 1024;
  if(!empty($_FILES[$fileKey]['size']) && $_FILES[$fileKey]['size'] > $maxSize){
    return "";
  }

  $ext = strtolower(pathinfo($_FILES[$fileKey]['name'], PATHINFO_EXTENSION));
  $allowed = ['jpg','jpeg','png','webp'];
  if(!in_array($ext, $allowed)){
    return "";
  }

  $folder = "../images/newsletter/campaigns/";
  if(!is_dir($folder)) mkdir($folder, 0755, true);

  $newName  = "camp_" . date("YmdHis") . "_" . bin2hex(random_bytes(5)) . "." . $ext;
  $fullPath = $folder . $newName;

  if(move_uploaded_file($_FILES[$fileKey]['tmp_name'], $fullPath)){
    return "images/newsletter/campaigns/" . $newName;
  }

  return "";
}

$action = $_POST['action'] ?? "";

/* =====================================================
   ✅ SAVE SETTINGS
===================================================== */
if($action === "save_settings"){

  $page_title    = trim($_POST['page_title'] ?? "");
  $page_subtitle = trim($_POST['page_subtitle'] ?? "");
  $from_name     = trim($_POST['from_name'] ?? "");
  $from_email    = trim($_POST['from_email'] ?? "");
  $reply_to      = trim($_POST['reply_to'] ?? "");

  if($page_title === "" || $page_subtitle === "" || $from_name === "" || $from_email === ""){
    go("admin_newsletter.php?saved=0");
  }

  if(!filter_var($from_email, FILTER_VALIDATE_EMAIL)){
    go("admin_newsletter.php?saved=0");
  }

  if($reply_to !== "" && !filter_var($reply_to, FILTER_VALIDATE_EMAIL)){
    $reply_to = "";
  }

  $bgPath = null;
  if(!empty($_FILES['bg_image']['name'])){

    if($_FILES['bg_image']['size'] > 4 * 1024 * 1024){
      go("admin_newsletter.php?saved=0");
    }

    $ext = strtolower(pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg','jpeg','png','webp'];

    if(in_array($ext, $allowed)){
      $folder = "../images/newsletter/";
      if(!is_dir($folder)) mkdir($folder, 0755, true);

      $newName = "news_" . date("YmdHis") . "_" . bin2hex(random_bytes(4)) . "." . $ext;
      $fullPath = $folder . $newName;

      if(move_uploaded_file($_FILES['bg_image']['tmp_name'], $fullPath)){
        $bgPath = "images/newsletter/".$newName;
      }
    }
  }

  try{
    if($bgPath){
      $stmt = $pdo->prepare("
        UPDATE iaos_newsletter_settings
        SET page_title=?, page_subtitle=?, bg_image=?, from_name=?, from_email=?, reply_to=?
        WHERE id=1
      ");
      $stmt->execute([$page_title,$page_subtitle,$bgPath,$from_name,$from_email,$reply_to]);
    } else {
      $stmt = $pdo->prepare("
        UPDATE iaos_newsletter_settings
        SET page_title=?, page_subtitle=?, from_name=?, from_email=?, reply_to=?
        WHERE id=1
      ");
      $stmt->execute([$page_title,$page_subtitle,$from_name,$from_email,$reply_to]);
    }
  } catch(Exception $e){
    go("admin_newsletter.php?saved=0");
  }

  go("admin_newsletter.php?saved=1");
}


/* =====================================================
   ✅ ADD SUBSCRIBER
===================================================== */
if($action === "add_subscriber"){

  $full_name = trim($_POST['full_name'] ?? "");
  $email     = trim($_POST['email'] ?? "");

  if(!filter_var($email, FILTER_VALIDATE_EMAIL)){
    go("admin_newsletter.php?saved=0");
  }

  try{
    $stmt = $pdo->prepare("
      INSERT INTO newsletter_subscribers(full_name,email,status)
      VALUES(?,?, 'active')
    ");
    $stmt->execute([$full_name, $email]);
  } catch(Exception $e){
    // ✅ ignore duplicates
  }

  go("admin_newsletter.php?saved=1");
}


/* =====================================================
   ✅ DELETE / ACTIVATE / UNSUBSCRIBE SUBSCRIBER
===================================================== */
if(in_array($action, ["delete_subscriber","activate_subscriber","unsubscribe_subscriber"])){

  $sid = (int)($_POST['subscriber_id'] ?? 0);
  if($sid <= 0) go("admin_newsletter.php");

  if($action === "delete_subscriber"){
    $stmt = $pdo->prepare("DELETE FROM newsletter_subscribers WHERE id=? LIMIT 1");
    $stmt->execute([$sid]);
  }

  if($action === "activate_subscriber"){
    $stmt = $pdo->prepare("UPDATE newsletter_subscribers SET status='active' WHERE id=? LIMIT 1");
    $stmt->execute([$sid]);
  }

  if($action === "unsubscribe_subscriber"){
    $stmt = $pdo->prepare("UPDATE newsletter_subscribers SET status='unsubscribed' WHERE id=? LIMIT 1");
    $stmt->execute([$sid]);
  }

  go("admin_newsletter.php?saved=1");
}


/* =====================================================
   ✅ ADD CAMPAIGN  (✅ NEW DEFAULT LINKS)
===================================================== */
if($action === "add_campaign"){

  $subject = trim($_POST['subject'] ?? "");
  if($subject === "") go("admin_newsletter.php");

  $defaultHtml = "<h2>Assalamu Alaikum</h2><p>Write your newsletter here...</p>";

  // ✅ default links
  $logo_link   = "https://iaosregina.com";
  $banner_link = "https://iaosregina.com";
  $button_link = "https://iaosregina.com";
  $button_text = "VISIT OUR WEBSITE";

  // ✅ Insert campaign with link fields
  $stmt = $pdo->prepare("
    INSERT INTO newsletter_campaigns
    (subject, html_body, logo_link, banner_link, button_link, button_text)
    VALUES (?,?,?,?,?,?)
  ");
  $stmt->execute([$subject, $defaultHtml, $logo_link, $banner_link, $button_link, $button_text]);

  $cid = (int)$pdo->lastInsertId();
  go("admin_newsletter.php?cid=".$cid."&saved=1");
}


/* =====================================================
   ✅ SAVE CAMPAIGN (✅ IMAGES + LINKS)
===================================================== */
if($action === "save_campaign"){

  $cid      = (int)($_POST['campaign_id'] ?? 0);
  $subject  = trim($_POST['subject'] ?? "");

  // ✅ do not hard trim html
  $html_body = $_POST['html_body'] ?? "";

  // ✅ LINKS (new)
  $logo_link   = trim($_POST['logo_link'] ?? "");
  $banner_link = trim($_POST['banner_link'] ?? "");
  $button_link = trim($_POST['button_link'] ?? "");
  $button_text = trim($_POST['button_text'] ?? "");

  // ✅ sanitize links (allow empty)
  if($logo_link   !== "" && !filter_var($logo_link, FILTER_VALIDATE_URL))   $logo_link = "";
  if($banner_link !== "" && !filter_var($banner_link, FILTER_VALIDATE_URL)) $banner_link = "";
  if($button_link !== "" && !filter_var($button_link, FILTER_VALIDATE_URL)) $button_link = "";

  if($button_text === "") $button_text = "VISIT OUR WEBSITE";

  if($cid <= 0 || $subject === "" || trim(strip_tags($html_body)) === ""){
    go("admin_newsletter.php");
  }

  // ✅ Get old images to keep OR delete if replaced
  $stmtOld = $pdo->prepare("SELECT image1, image2 FROM newsletter_campaigns WHERE id=? LIMIT 1");
  $stmtOld->execute([$cid]);
  $old = $stmtOld->fetch(PDO::FETCH_ASSOC);

  $oldImg1 = $old['image1'] ?? "";
  $oldImg2 = $old['image2'] ?? "";

  // ✅ Upload new optional images
  $newImg1 = uploadCampaignImage("image1_file");
  $newImg2 = uploadCampaignImage("image2_file");

  // ✅ If admin checked remove boxes
  $remove1 = isset($_POST['remove_image1']) ? 1 : 0;
  $remove2 = isset($_POST['remove_image2']) ? 1 : 0;

  // ✅ Decide final paths
  $finalImg1 = $oldImg1;
  $finalImg2 = $oldImg2;

  if($remove1 === 1){
    deleteFileSafe($oldImg1);
    $finalImg1 = "";
  }
  if($remove2 === 1){
    deleteFileSafe($oldImg2);
    $finalImg2 = "";
  }

  if($newImg1 !== ""){
    deleteFileSafe($oldImg1);
    $finalImg1 = $newImg1;
  }

  if($newImg2 !== ""){
    deleteFileSafe($oldImg2);
    $finalImg2 = $newImg2;
  }

  // ✅ Save everything (IMAGES + LINKS)
  $stmt = $pdo->prepare("
    UPDATE newsletter_campaigns
    SET subject=?,
        html_body=?,
        image1=?,
        image2=?,
        logo_link=?,
        banner_link=?,
        button_link=?,
        button_text=?
    WHERE id=? LIMIT 1
  ");
  $stmt->execute([
    $subject,
    $html_body,
    $finalImg1,
    $finalImg2,
    $logo_link,
    $banner_link,
    $button_link,
    $button_text,
    $cid
  ]);

  go("admin_newsletter.php?cid=".$cid."&saved=1");
}


/* =====================================================
   ✅ DELETE CAMPAIGN (✅ DELETE IMAGES ALSO)
===================================================== */
if($action === "delete_campaign"){

  $cid = (int)($_POST['campaign_id'] ?? 0);
  if($cid <= 0) go("admin_newsletter.php");

  // ✅ delete images first
  $stmtOld = $pdo->prepare("SELECT image1, image2 FROM newsletter_campaigns WHERE id=? LIMIT 1");
  $stmtOld->execute([$cid]);
  $old = $stmtOld->fetch(PDO::FETCH_ASSOC);

  if($old){
    deleteFileSafe($old['image1'] ?? "");
    deleteFileSafe($old['image2'] ?? "");
  }

  $pdo->prepare("DELETE FROM newsletter_queue WHERE campaign_id=?")->execute([$cid]);
  $pdo->prepare("DELETE FROM newsletter_campaigns WHERE id=? LIMIT 1")->execute([$cid]);

  go("admin_newsletter.php?saved=1");
}


/* =====================================================
   ✅ CREATE QUEUE (FAST BULK)
===================================================== */
if($action === "create_queue"){

  $cid = (int)($_POST['campaign_id'] ?? 0);
  if($cid <= 0) go("admin_newsletter.php");

  try{
    $pdo->beginTransaction();

    $pdo->prepare("DELETE FROM newsletter_queue WHERE campaign_id=?")->execute([$cid]);

    $stmt = $pdo->prepare("
      INSERT INTO newsletter_queue (campaign_id, subscriber_id, status)
      SELECT ?, id, 'pending'
      FROM newsletter_subscribers
      WHERE status='active'
    ");
    $stmt->execute([$cid]);

    $pdo->commit();
  } catch(Exception $e){
    $pdo->rollBack();
    go("admin_newsletter.php?cid=".$cid."&saved=0");
  }

  go("admin_newsletter.php?cid=".$cid."&sent=1");
}


/* =====================================================
   DEFAULT REDIRECT
===================================================== */
go("admin_newsletter.php");
