<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Evening School Program | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner2.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Evening School Program</h1>
    <p class="lead">IAOS Regina Quran & Islamic Studies Evening Program</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <div class="mb-5 text-white">
      <h3 class="greet-title text-white greet-title-in fw-bold mb-3">PROGRAM OVERVIEW</h3>
      <p>The <strong>Evening School Program</strong> at IAOS Regina provides a structured Quran and Islamic education for children after regular school hours. It focuses on nurturing Islamic values, improving Quranic recitation, and developing strong moral character in a safe and engaging environment.</p>

      <h5 class="fw-bold text-success mt-4">Program Objectives:</h5>
      <ul>
        <li>To teach students how to read and recite the Holy Quran with proper Tajweed.</li>
        <li>To provide basic Islamic education including Salah, Aqeedah, Akhlaq, and Seerah.</li>
        <li>To strengthen moral values, discipline, and love for Allah and the Prophet ﷺ.</li>
        <li>To foster respect, cooperation, and good manners among students.</li>
      </ul>

      <h5 class="fw-bold text-success mt-4">Program Details:</h5>
      <ul>
        <li><strong>Academic Session:</strong> September 2025 – June 2026</li>
        <li><strong>Days:</strong> Monday to Thursday</li>
        <li><strong>Time:</strong> 5:30 PM – 7:30 PM</li>
        <li><strong>Location:</strong> IAOS Masjid, 3273 Montague Street, Regina, SK</li>
        <li><strong>Age Group:</strong> 6 – 16 years old (Boys & Girls)</li>
        <li><strong>Monthly Fees:</strong> $80/month per child | $60 for siblings</li>
        <li><strong>Payment Method:</strong> EFT (Electronic Fund Transfer)</li>
      </ul>
    </div>

    <!-- ================= RULES ACCORDION ================= -->
    <div class="accordion mb-5" id="rulesAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseRules">
            Rules and Regulations
          </button>
        </h2>
        <div id="collapseRules" class="accordion-collapse collapse">
          <div class="accordion-body">
            <p><strong>Attendance:</strong> Regular attendance and punctuality are essential. More than three unexcused absences may result in review of enrollment.</p>
            <p><strong>Discipline:</strong> Students are expected to behave respectfully and follow instructions from teachers. Misbehavior, disrespect, or disruption may lead to disciplinary action.</p>
            <p><strong>Dress Code:</strong> Students must wear modest clothing. Boys should wear a topi/head covering; girls should wear hijab during class and Salah.</p>
            <p><strong>Homework:</strong> Parents are encouraged to help their children review lessons daily at home.</p>
            <p><strong>Safety:</strong> Parents are responsible for timely pick-up. IAOS is not liable for students left after school hours.</p>
            <p><strong>Electronic Devices:</strong> Mobile phones, games, or music players are strictly not allowed.</p>
            <p><strong>Financial Assistance:</strong> Limited aid may be available for families with special circumstances upon approval.</p>
            <p><strong>Contact:</strong> <a href="mailto:schooladmin@iaosregina.com">schooladmin@iaosregina.com</a></p>
          </div>
        </div>
      </div>
    </div>

    <!-- ================= REGISTRATION FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="fw-bold text-success mb-4 text-center">Evening School Registration Form</h4>
      <p class="text-center mb-4">Please fill out the required information. Fields marked with * are mandatory.</p>

      <form>
        <div class="mb-3">
          <label>Email Address *</label>
          <input type="email" class="form-control" placeholder="e.g. tahirhafeez764@gmail.com" required>
        </div>

        <div class="mb-3">
          <label>Student’s Full Name *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Parent/Guardian Full Name *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Date of Birth *</label>
            <input type="date" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Gender *</label>
            <select class="form-select" required>
              <option value="">Select</option>
              <option>Male</option>
              <option>Female</option>
            </select>
          </div>
        </div>

        <div class="mb-3">
          <label>Contact Phone Number (Home + Cell) *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Home Address *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Emergency Contact Person, Relationship & Phone *</label>
          <textarea class="form-control" rows="2" placeholder="e.g. Ahmed Khan, Father, 306-555-7890" required></textarea>
        </div>

        <div class="mb-3">
          <label>Preferred Class Level *</label>
          <select class="form-select" required>
            <option value="">Select Level</option>
            <option>Beginner (Qaida / Basic Reading)</option>
            <option>Intermediate (Reading with Tajweed)</option>
            <option>Advanced (Juz / Hifz Focus)</option>
          </select>
        </div>

        <div class="mb-3">
          <label>Previous Islamic School / Teacher (if any)</label>
          <input type="text" class="form-control" placeholder="Optional">
        </div>

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" id="agreeRules" required>
          <label class="form-check-label" for="agreeRules">
            I certify that I have read the <a href="#collapseRules" data-bs-toggle="collapse" class="text-success fw-semibold text-decoration-none">rules and regulations</a> and will abide by them.
          </label>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Registration</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY=window.scrollY;
const donateBtn=document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll',()=>{donateBtn.style.opacity=window.scrollY>lastScrollY?'0':'1';lastScrollY=window.scrollY;});
</script>
</body>
</html>
