<?php
/* ---------------------------------------------------
   1) ADMIN EDITABLE CONTENT (HEADER + INTRO)
---------------------------------------------------- */
require_once "admin_pannel/db.php"; // gives $pdo

$header = $pdo->query("SELECT * FROM events_page_header WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$intro  = $pdo->query("SELECT * FROM events_page_intro WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* ---------------------------------------------------
   2) EVENTS LIST (NOT EXPIRED + ACTIVE STATUS)
   ✅ Show until expiry_date
---------------------------------------------------- */
require_once "../db.php";
$pdoEvents = get_db();

$stmt = $pdoEvents->prepare("
    SELECT id, title, subtitle, event_date, expiry_date, image, description,
           capacity, booked, base_price, member_price, link, status
    FROM events
    WHERE
        -- ✅ show events until expiry date/time
        expiry_date >= NOW()

        -- ✅ show only valid statuses (open + soldout)
        AND status IN ('open', 'soldout')

    ORDER BY expiry_date ASC
");
$stmt->execute();
$eventsList = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ✅ Paragraphs statement (we will reuse inside loop) */
$paraStmt = $pdoEvents->prepare("
    SELECT paragraph_text
    FROM event_paragraphs
    WHERE event_id = ?
    ORDER BY id ASC
");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Events | IAOS Regina</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- NAVBAR -->
<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5"
         style="background:url('<?= htmlspecialchars($header['bg_image']) ?>') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($header['page_title']) ?></h1>
    <p class="lead"><?= htmlspecialchars($header['page_subtitle']) ?></p>
  </div>
</section>

<!-- ================= EVENTS SECTION ================= -->
<section class="py-5">
  <div class="container-xl">

    <!-- INTRO BLOCK -->
    <div class="mb-5 text-white">
      <h3 class="greet-title fw-bold mb-3 greet-title-in text-white">
        <?= htmlspecialchars($intro['heading']) ?>
      </h3>
      <p><?= nl2br(htmlspecialchars($intro['paragraph'])) ?></p>
    </div>

    <?php if (empty($eventsList)): ?>
      <div class="alert alert-light border">
        No upcoming events available.
      </div>
    <?php endif; ?>

    <!-- EVENTS LOOP -->
    <?php foreach($eventsList as $event):

        $eventDate  = strtotime($event['event_date']);
        $expiryDate = strtotime($event['expiry_date']);

        // ✅ status badge
        $status = strtolower(trim($event['status']));
        $badgeClass = ($status === 'open') ? 'bg-success' : 'bg-danger';
        $badgeText  = ($status === 'open') ? 'Open' : 'Sold Out';

        // ✅ Fetch paragraphs for this event
        $paraStmt->execute([$event['id']]);
        $eventParagraphs = $paraStmt->fetchAll(PDO::FETCH_ASSOC);

    ?>
    <div class="event-box d-flex flex-column flex-md-row align-items-center mb-5 p-4 rounded shadow-sm bg-white">

      <!-- LEFT CONTENT -->
      <div class="event-content flex-grow-1 pe-md-4">

        <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
          <h4 class="fw-bold text-success mb-2">
            <?= htmlspecialchars($event['title']) ?>
          </h4>

          <span class="badge <?= $badgeClass ?> px-3 py-2">
            <?= $badgeText ?>
          </span>
        </div>

        <p class="text-muted mb-1">
          <i class="bi bi-calendar-event me-2"></i>
          <?= date("l, F d, Y", $eventDate) ?>
        </p>

        <!-- ✅ Expiry Date -->
        <p class="text-muted mb-2">
          <i class="bi bi-hourglass-split me-2"></i>
          <strong>Valid Till:</strong> <?= date("l, F d, Y h:i A", $expiryDate) ?>
        </p>

        <p class="text-muted mb-3">
          <i class="bi bi-geo-alt me-2"></i>
          <?= htmlspecialchars($event['subtitle']) ?>
        </p>

        <!-- ✅ Short Description -->
        <p><?= nl2br(htmlspecialchars($event['description'])) ?></p>

        <!-- ✅ EVENT PARAGRAPHS (AFTER SHORT DESCRIPTION) -->
        <?php if (!empty($eventParagraphs)): ?>
          <div class="mt-3">
            <?php foreach($eventParagraphs as $p): ?>
              <p class="mb-3">
                <?= nl2br(htmlspecialchars($p['paragraph_text'])) ?>
              </p>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>

        <ul class="list-unstyled mb-4">
          <li><strong>Total Capacity:</strong> <?= (int)$event['capacity'] ?></li>
          <li><strong>Sold Seats:</strong> <?= (int)$event['booked'] ?></li>
          <li><strong>Ticket Price:</strong> $<?= htmlspecialchars($event['base_price']) ?></li>
          <li><strong>Member Price:</strong> $<?= htmlspecialchars($event['member_price']) ?></li>
        </ul>

        <!-- ✅ FIXED BUTTON -->
        <?php if (!empty($event['id'])): ?>
          <a href="selectedevent.php?eventID=<?= (int)$event['id'] ?>"
             class="btn btn-success px-4 py-2" target="_blank">
            <i class="bi bi-ticket-perforated-fill me-2"></i>
            Buy / Register
          </a>
        <?php endif; ?>

      </div>

      <!-- RIGHT IMAGE -->
      <div class="event-image mt-4 mt-md-0 ms-md-4">
        <img src="../<?= htmlspecialchars($event['image']) ?>"
             class="rounded shadow-sm"
             alt="<?= htmlspecialchars($event['title']) ?>"
             style="width:200px; height:auto;">
      </div>

    </div>
    <?php endforeach; ?>

  </div>
</section>
<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
