<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set("America/Regina");

try {
  $pdo = new PDO("mysql:host=localhost;dbname=u290827053_iaos;charset=utf8mb4", "root", "");
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo json_encode(["error" => $e->getMessage()]);
  exit;
}

// 🗓 determine selected or current month
$monthParam = $_GET['month'] ?? date("F");
$monthNum = date('m', strtotime($monthParam . " 1"));
$year = date("Y");
$monthKey = "$year-$monthNum";

$stmt = $pdo->prepare("SELECT * FROM prayer_times WHERE prayer_date LIKE ? ORDER BY prayer_date ASC");
$stmt->execute(["$monthKey%"]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($rows as &$r) {
  // ✅ Add readable day name
  $r['day'] = date("D", strtotime($r['prayer_date']));

  // ✅ Format only time fields — NOT hijri
  $timeFields = ['fajar','zuhar','asar','magrib_begins','isha','jumah1','jumah2'];
  foreach ($timeFields as $key) {
    if (!empty($r[$key]) && strtotime($r[$key]) !== false) {
      $r[$key] = date("g:i A", strtotime($r[$key]));
    }
  }

  // ✅ Keep Hijri text as-is (no formatting)
  $r['hijri'] = $r['hijri'] ?? '';
}

echo json_encode($rows);
