<?php
require_once "../db.php";  // ✅ loads get_db()
date_default_timezone_set("America/Regina");

// ✅ get PDO connection
$pdo = get_db();

// ✅ Helper: nice time formatting
function fmt($t) {
    if (!$t) return null;
    if (strtotime($t) === false) return $t;
    return date("g:i A", strtotime($t));
}

// ✅ Today date
$today = date("Y-m-d");

// ✅ Fetch today's timings
$stmt = $pdo->prepare("SELECT * FROM prayer_times WHERE prayer_date = ? LIMIT 1");
$stmt->execute([$today]);
$todayRow = $stmt->fetch(PDO::FETCH_ASSOC);

// ✅ Fetch Jummah of current week
$weekStart = date("Y-m-d", strtotime("monday this week"));
$weekEnd   = date("Y-m-d", strtotime("sunday this week"));

$stmt2 = $pdo->prepare("
    SELECT jumah1, jumah2
    FROM prayer_times
    WHERE prayer_date BETWEEN ? AND ?
      AND DAYNAME(prayer_date) = 'Friday'
    LIMIT 1
");
$stmt2->execute([$weekStart, $weekEnd]);
$jummahRow = $stmt2->fetch(PDO::FETCH_ASSOC);

// ✅ Format today row
if ($todayRow) {
        foreach ([
        'fajar_begins','fajar',
        'zuhar_begins','zuhar',
        'asar_begins','asar',
        'sunset',               // ✅ ADDED
        'magrib_begins',
        'isha_begins','isha'
    ] as $f) {
        if (!empty($todayRow[$f])) {
            $todayRow[$f] = fmt($todayRow[$f]);
        }
    }
}

// ✅ Format Jummah times
if ($jummahRow) {
    $jummahRow['jumah1'] = fmt($jummahRow['jumah1']);
    $jummahRow['jumah2'] = fmt($jummahRow['jumah2']);
}

header("Content-Type: application/json");
echo json_encode([
    "today"  => $todayRow,
    "jummah" => $jummahRow
]);
