<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Membership Benefits | IAOS Regina</title>

  <!-- Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">

  <style>
    body {
      font-family: 'Montserrat', sans-serif;
    }

    .page-header {
      position: relative;
      background-size: cover;
      background-position: center;
    }

    .page-header .overlay {
      background: rgba(0, 0, 0, 0.5);
    }

    /* Section Intro */
    .section-intro {
      background-color: #0f5132;
      color: #fff;
      border-radius: 12px;
      padding: 25px;
      margin-bottom: 40px;
    }

    .section-intro ul {
      margin-top: 15px;
      padding-left: 20px;
    }

    .section-intro ul li {
      margin-bottom: 8px;
    }

    /* Card styles */
    .discount-card, .card {
      background-color: #ffffff;
      border-radius: 12px;
      padding: 15px;
      margin-bottom: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .discount-card:hover, .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(0,0,0,0.2);
    }

    .card-title {
      font-weight: 700;
      color: #0f5132;
    }

    .card-text {
      margin-bottom: 5px;
    }

    /* Center and contain text inside section */
    .about-section .container-xl {
      max-width: 900px;
      margin: 0 auto;
    }

    /* Floating Prayer Button */
    .prayer-btn {
      position: fixed;
      bottom: 90px;
      right: 25px;
      z-index: 1000;
      cursor: pointer;
    }

    .prayer-btn img {
      width: 60px;
      transition: transform 0.3s ease;
    }

    .prayer-btn img:hover {
      transform: scale(1.1);
    }

    /* Mobile Donate Button */
    .mobile-donate-btn {
      display: none;
      position: fixed;
      bottom: 20px;
      left: 50%;
      transform: translateX(-50%);
      background-color: #198754;
      color: #fff;
      padding: 10px 25px;
      border-radius: 50px;
      font-weight: 600;
      text-decoration: none;
      box-shadow: 0 5px 20px rgba(0,0,0,0.3);
      transition: all 0.3s ease;
      z-index: 1001;
    }

    .mobile-donate-btn:hover {
      background-color: #157347;
    }

    @media (max-width: 768px) {
      .mobile-donate-btn {
        display: inline-block;
      }
    }
  </style>
</head>

<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner5.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Membership Benefits & Discounts</h1>
    <p class="lead">Exclusive offers for IAOS Regina members — support community and enjoy perks!</p>
  </div>
</section>

<!-- ================= INTRO / DISCOUNT INFO ================= -->

<section class="about-section py-5 text-white">
  <div class="container-xl">
    <div class="mb-5">
     
      <ul class="fs-5">

      </ul>
    </div>

    <div class="mb-5">
      <h3 class="greet-title greet-title-in text-white fw-bold mb-3"> Supporting Local Businesses</h3>
      <p>We are proud to partner with trusted local businesses to support our community. As a paid member, you can enjoy special discounts and offers when you shop or use services from our supporting partners.</p>
      <ul>
        <li>Save money</li>
        <li>Support the local Muslim community</li>
        <li>Help local businesses grow</li>
      </ul>
    </div>

    <div class="mb-5">
      <h3 class="greet-title greet-title-in text-white fw-bold mb-3">For Mosque Members</h3>
      <p class="mb-4">
        View the discount percentage offered by each supporting business.  
        Show your membership card or number to claim your discount.  
        Discounts are available in-store.  
       <br> <strong>Only paid members of IAOS Regina are eligible for these offers.</strong>
      </p>


<!-- Discount Cards -->
<div class="row g-3 justify-content-center">

  <!-- Card 1 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Example Store</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Restaurant</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 10% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> Dine-in only</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

  <!-- Repeat for Cards 2 to 8 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Example Service</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Auto Repair</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 15% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> On all services</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

  <!-- Card 3 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Coffee Corner</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Cafe</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 12% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> All drinks</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

  <!-- Card 4 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Tech Solutions</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Electronics</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 8% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> On laptops</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

  <!-- Card 5 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Fashion Hub</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Clothing</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 20% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> Selected items</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

  <!-- Card 6 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Fitness Center</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Gym</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 15% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> Membership</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

  <!-- Card 7 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Bakery Delight</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Bakery</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 10% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> All breads</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

  <!-- Card 8 -->
  <div class="col-6 col-sm-6 col-md-4 col-lg-3">
    <div class="card discount-card">
      <div class="card-body">
        <h6 class="card-title text-success fw-bold mb-2">Book World</h6>
        <p class="card-text mb-0"><strong>Category:</strong> Bookstore</p>
        <p class="card-text mb-0"><strong>Discount:</strong> 5% OFF</p>
        <p class="card-text mb-0"><strong>Offer:</strong> All books</p>
        <p class="card-text mb-0"><strong>Location:</strong> Regina</p>
        <p class="card-text mb-0"><strong>Contact:</strong> 306-xxx-xxxx</p>
      </div>
    </div>
  </div>

</div>

<style>
.discount-card {
  background-color: #ffffff;
  border-radius: 12px;
  box-shadow: 0 4px 15px rgba(0,0,0,0.1);
  transition: transform 0.3s ease, box-shadow 0.3s ease;
  aspect-ratio: 1 / 1; /* Perfect square */
  padding: 12px;
  font-size: 0.8rem;
  display: flex;
  flex-direction: column;
  justify-content: center;
  text-align: left;
}

.discount-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 10px 25px rgba(0,0,0,0.2);
}

.discount-card .card-title {
  font-size: 0.85rem;
  line-height: 1rem;
  color: #198754;
}

.discount-card .card-text {
  font-size: 0.75rem;
  line-height: 0.9rem;
  color: #212529;
}
</style>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Fixed Donate Button (Mobile Only) -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>

<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
