<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Membership | IAOS Regina</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">

  <style>
    /* ================= Purpose Section ================= */
    .membership-purpose {
      background: linear-gradient(135deg, #d4edda, #c3e6cb); /* light green gradient */
      color: #0f5132; /* dark green text */
      border-radius: 20px;
      padding: 40px 30px;
      margin: 40px 0;
      box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .membership-purpose h2 {
      font-family: 'Montserrat', sans-serif;
      font-weight: 700;
      font-size: 2rem;
      margin-bottom: 20px;
      position: relative;
    }

    .membership-purpose h2::after {
      content: '';
      display: block;
      width: 60px;
      height: 4px;
      background-color: #0f5132; /* underline */
      margin-top: 8px;
      border-radius: 2px;
    }

    .membership-purpose h4 {
      font-weight: 600;
      margin-top: 30px;
      margin-bottom: 15px;
    }

    .membership-purpose p, 
    .membership-purpose li {
      font-size: 1rem;
      line-height: 1.7;
    }

    .membership-purpose ul {
      list-style: none;
      padding-left: 20px;
    }

    .membership-purpose ul li {
      margin-bottom: 12px;
      padding-left: 20px;
      position: relative;
    }

    .membership-purpose ul li::before {
      content: '✔';
      color: #0f5132;
      position: absolute;
      left: 0;
    }

    /* ================= Membership Cards ================= */
    .membership-card {
      background: #0f5132;
      border-radius: 12px;
      padding: 25px;
      text-align: center;
      color: #fff;
      cursor: pointer;
      transition: all 0.3s ease;
      margin-bottom: 20px;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      height: 100%; /* Make all cards equal height */
    }

    .membership-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(0,0,0,0.2);
    }

    .membership-card h5 {
      font-weight: 700;
      margin-bottom: 15px;
    }

    .membership-card button {
      background-color: #fff;
      color: #0f5132;
      border-radius: 50px;
      padding: 6px 20px;
      border: none;
      transition: none;
      align-self: center;
    }

    .membership-card button:hover {
      background-color: #fff;
      color: #0f5132;
    }

    /* ================= Page Header ================= */
    .page-header {
      position: relative;
      background: url('images/banner4.jpg') center/cover no-repeat;
      padding: 100px 0;
      text-align: center;
      color: #fff;
    }

    .page-header .overlay {
      position: absolute;
      top:0;
      left:0;
      width:100%;
      height:100%;
      background: rgba(0,0,0,0.5);
      z-index:0;
    }

    .page-header h1, .page-header p {
      position: relative;
      z-index: 1;
    }
  </style>
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- ================= NAVBAR ================= -->
<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Become a Member of IAOS</h1>
    <p class="lead">Support your community — join IAOS and earn rewards from Allah SWT.</p>
  </div>
</section>

<!-- ================= PURPOSE OF MEMBERSHIP ================= -->
<section class="container-xl my-5">
  <div class="membership-box d-flex flex-column p-4 rounded shadow-sm bg-white">
    
    <!-- Text Content -->
    <div class="membership-content">
      <h4 class="fw-bold text-success mb-3">Purpose of Membership</h4>
      <p class="text-muted mb-3">
        Becoming a member of <strong>IAOS Regina</strong> helps sustain and strengthen the mosque and its programs, supporting education, worship, and community development throughout Regina.
      </p>

      <h5 class="fw-semibold mb-2">Benefits to the Community and Mosque:</h5>
      <ul class="list-unstyled mb-3 text-muted">
        <li><strong>Sustain Vital Programs:</strong> Membership supports education, worship, and community development programs for the whole Muslim community.</li>
        <li><strong>Enhance Facilities:</strong> Contributions help maintain and improve mosque facilities for worship, events, and community gatherings.</li>
        <li><strong>Strengthen Community Bonds:</strong> Membership encourages active participation and gives members a voice in decision-making.</li>
        <li><strong>Exclusive Member Perks:</strong> Enjoy benefits like business discounts, priority event access, and special programs.</li>
      </ul>

      <p class="text-muted mb-0">
        By joining, you are helping IAOS Regina continue over 50 years of service while enjoying tangible benefits as part of a growing, supportive network.
      </p>
    </div>

  </div>
</section>



<!-- ================= MEMBERSHIP BUTTONS ================= -->
<div class="container-xl mb-5">
  <div class="row g-4 text-center">
    <div class="col-md-6 col-lg-3 d-flex">
      <div class="membership-card">
        <h5>Become a Monthly Member</h5>
        <button onclick="window.location.href='connect.php?type=monthly'">Join Now</button>
      </div>
    </div>
    <div class="col-md-6 col-lg-3 d-flex">
      <div class="membership-card">
        <h5>Voting Member</h5>
        <button onclick="window.location.href='member.php'">Join Now</button>
      </div>
    </div>
    <div class="col-md-6 col-lg-3 d-flex">
      <div class="membership-card">
        <h5>Business Registration</h5>
        <button onclick="window.location.href='businesssupport.php'">Register</button>
      </div>
    </div>
    <div class="col-md-6 col-lg-3 d-flex">
      <div class="membership-card">
        <h5>Members Discount</h5>
        <button onclick="window.location.href='memberbenefit.php'">Get Discount</button>
      </div>
    </div>
  </div>
</div>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<!-- ================= FOOTER ================= -->
<?php include 'footer.php'; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
