<?php
require_once "admin_pannel/db.php";

/* GLOBAL SETTINGS */
$set = $pdo->query("SELECT * FROM iaos_news_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* POSTS */
$posts = $pdo->query("SELECT * FROM iaos_news_posts ORDER BY position DESC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

/* PARAGRAPHS */
$paras = [];
if (!empty($posts)) {
  $ids = array_column($posts,'id');
  $in = implode(",", array_fill(0,count($ids),'?'));

  $stmt = $pdo->prepare("SELECT * FROM iaos_news_paragraphs WHERE post_id IN ($in) ORDER BY position DESC,id DESC");
  $stmt->execute($ids);

  foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $p) {
    $paras[$p['post_id']][] = $p;
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($set['page_title']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">
<link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<section class="page-header text-center text-white py-5"
  style="background:url('<?= htmlspecialchars($set['bg_image']) ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold"><?= htmlspecialchars($set['page_title']) ?></h1>
    <p class="lead"><?= htmlspecialchars($set['page_subtitle']) ?></p>
  </div>
</section>

<section class="py-5">
<div class="container-xl">

<?php if (empty($posts)): ?>
  <div class="text-center text-white-50 py-5">
    <h4>No updates right now.</h4>
    <p>Please check again soon, in shaa Allah.</p>
  </div>
<?php endif; ?>

<?php foreach ($posts as $post): ?>
<div class="update-box mb-5">

  <div class="update-date">
    <?= htmlspecialchars(date('F j, Y', strtotime($post['publish_date']))) ?>
  </div>

  <div class="update-title">
    <?= htmlspecialchars($post['intro_heading']) ?>
  </div>

  <div class="update-content">
    <p><?= nl2br(htmlspecialchars($post['intro_text'])) ?></p>
  </div>

  <?php foreach (($paras[$post['id']] ?? []) as $p): ?>
    <div class="update-content">
      <p><?= nl2br(htmlspecialchars($p['para_text'])) ?></p>
    </div>
  <?php endforeach; ?>

</div>

<hr class="border-secondary opacity-25 my-5">
<?php endforeach; ?>

</div>
</section>


<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>



<?php include 'footer.php'; ?>

</body>
</html>
