<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Part-Time Quran Hifz Program | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner4.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Part-Time Quran Hifz Program</h1>
    <p class="lead">Registration (2025-2026)</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <div class="mb-5 text-white">
      <h3 class="greet-title text-white greet-title-in fw-bold mb-3">PROGRAM DETAILS</h3>
      <p>This program is designed for boys and girls who wish to memorize the Holy Quran while managing their regular school schedule. Classes are conducted by qualified teachers at IAOS Masjid in a disciplined and spiritual environment.</p>

      <h5 class="fw-bold text-success mt-4">Program Information:</h5>
      <ul>
        <li><strong>Academic Session:</strong> Ongoing throughout the year</li>
        <li><strong>Location:</strong> IAOS Masjid – 3273 Montague Street, Regina, SK</li>
        <li><strong>Class Days & Timing:</strong> 
          <ul>
            <li>Friday: 6:00 PM – 8:00 PM (all year)</li>
            <li>Saturday & Sunday: 2:00 PM – 5:00 PM (September – June)</li>
            <li>Saturday & Sunday: 10:15 AM – 1:15 PM (July – August)</li>
          </ul>
        </li>
        <li><strong>Age Limit:</strong> Minimum 6 years (no maximum age)</li>
        <li><strong>Pre-requisite:</strong> Able to read the Quran without difficulty</li>
        <li><strong>Monthly Fees:</strong> $60/month per child, $50 for siblings</li>
        <li><strong>Payment Method:</strong> EFT (Electronic Fund Transfer) only</li>
      </ul>
    </div>

    <!-- ================= TERMS ACCORDION ================= -->
    <div class="accordion mb-5" id="termsAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingTerms">
          <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTerms">
            Information and Rules & Regulations
          </button>
        </h2>
        <div id="collapseTerms" class="accordion-collapse collapse" data-bs-parent="#termsAccordion">
          <div class="accordion-body">
            <p>All students are expected to maintain punctual attendance and respectful conduct. Parents are encouraged to communicate regularly with teachers via the official WhatsApp group.</p>
            <ul>
              <li>Bring your Quran daily; do not leave it at the Masjid.</li>
              <li>Maintain at least 75% attendance. Three unexcused absences may lead to removal from the register.</li>
              <li>No toys, mobile phones, or games allowed.</li>
              <li>Students must be picked up promptly after class.</li>
              <li>Misbehavior or inappropriate language may result in disciplinary action or expulsion.</li>
              <li>Financial assistance is available for special cases upon review.</li>
              <li>For concerns, contact <a href="mailto:schooladmin@iaosregina.com">schooladmin@iaosregina.com</a>.</li>
            </ul>
            <p class="mt-3"><strong>Note:</strong> Parents wishing to withdraw their child must email IAOS School Admin at least 2 weeks in advance to allow new students to join.</p>
          </div>
        </div>
      </div>
    </div>

    <!-- ================= PAYMENT BUTTON ================= -->
    <div class="text-center mb-5">
      <h5 class="text-white fw-bold mb-3">Payment Option</h5>
      <button class="btn btn-success px-4 py-2"><i class="bi bi-credit-card-2-front"></i> Pay $60 /month</button>
    </div>

    <!-- ================= REGISTRATION FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="fw-bold text-success mb-4 text-center">Part-Time Quran Hifz Program Registration Form</h4>
      <p class="text-center mb-4">Please fill out the following mandatory information. Fields marked with * are required.</p>

      <form>
        <div class="mb-3">
          <label>Email *</label>
          <input type="email" class="form-control" placeholder="e.g. tahirhafeez764@gmail.com" required>
        </div>

        <div class="mb-3">
          <label>Student’s Full Name *</label>
          <input type="text" class="form-control" placeholder="As per Health Card or valid ID" required>
        </div>

        <div class="mb-3">
          <label>Parent/Guardian’s/Spouse Full Name *</label>
          <input type="text" class="form-control" placeholder="As per Government ID" required>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Date of Birth *</label>
            <input type="date" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Gender *</label>
            <select class="form-select" required>
              <option value="">Select</option>
              <option>Male</option>
              <option>Female</option>
            </select>
          </div>
        </div>

        <div class="mb-3">
          <label>Health Card Number *</label>
          <input type="text" class="form-control" placeholder="Enter Health Card Number" required>
        </div>

        <div class="mb-3">
          <label>Contact Phone Number (Home + Cell) *</label>
          <input type="text" class="form-control" placeholder="e.g. 306-555-1234" required>
        </div>

        <div class="mb-3">
          <label>Home Address *</label>
          <input type="text" class="form-control" placeholder="Street, City, Province, Postal Code" required>
        </div>

        <div class="mb-3">
          <label>Phone number to connect through WhatsApp Group *</label>
          <input type="text" class="form-control" placeholder="Enter active WhatsApp number" required>
        </div>

        <div class="mb-3">
          <label>Emergency Contact Person and Phone Number *</label>
          <input type="text" class="form-control" placeholder="e.g. Ali Khan – Father – 306-123-4567" required>
        </div>

        <div class="mb-3">
          <label>Allergies / Medical Conditions</label>
          <textarea class="form-control" rows="3" placeholder="Specify any medical issues or allergies"></textarea>
        </div>

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" id="agreeRules" required>
          <label class="form-check-label" for="agreeRules">
            I certify that I have read the <a href="#collapseTerms" data-bs-toggle="collapse" class="text-success fw-semibold text-decoration-none">rules and regulations</a> and will abide by them.
          </label>
        </div>

        <div class="form-check mb-4">
          <input class="form-check-input" type="checkbox" id="copyResponses">
          <label class="form-check-label" for="copyResponses">Send me a copy of my responses</label>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Registration</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY=window.scrollY;
const donateBtn=document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll',()=>{donateBtn.style.opacity=window.scrollY>lastScrollY?'0':'1';lastScrollY=window.scrollY;});
</script>
</body>
</html>
