<?php
require_once "admin_pannel/db.php";

/* -------------------------
   LOAD PAGE HEADER SETTINGS
--------------------------*/
$set = $pdo->query("SELECT * FROM facility_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* -------------------------
   LOAD SECTIONS
--------------------------*/
$sections = $pdo->query("
    SELECT * FROM facility_sections 
    ORDER BY position ASC
")->fetchAll(PDO::FETCH_ASSOC);

/* -------------------------
   LOAD PARAGRAPHS
--------------------------*/
$paras_raw = $pdo->query("
    SELECT * FROM facility_paragraphs 
    ORDER BY section_id ASC, position ASC
")->fetchAll(PDO::FETCH_ASSOC);

$paras = [];
foreach ($paras_raw as $p) {
    $paras[$p['section_id']][] = $p;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($set['page_title']) ?> | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5"
 style="background:url('<?= htmlspecialchars($set['bg_image']) ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-3"><?= htmlspecialchars($set['page_title']) ?></h1>
    <p class="lead fst-italic"><?= htmlspecialchars($set['page_subtitle']) ?></p>
  </div>
</section>


<!-- ================= MAIN CONTENT ================= -->
<section class="py-5 bg-light">
  <div class="container-xl">

    <!-- RENDER ALL SECTIONS -->
    <?php foreach ($sections as $s): ?>
      <div class="mb-5">

        <!-- Section Heading -->
        <h3 class="greet-title greet-title-in mb-4">
          <?= htmlspecialchars($s['section_title']) ?>
        </h3>

        <!-- Paragraphs -->
        <?php if (!empty($paras[$s['id']])): ?>

          <?php foreach ($paras[$s['id']] as $p): ?>

            <?php if ($p['type'] == 'heading'): ?>
              <h5 class="fw-bold mt-3"><?= htmlspecialchars($p['para_text']) ?></h5>

            <?php elseif ($p['type'] == 'paragraph'): ?>
              <p><?= nl2br(htmlspecialchars($p['para_text'])) ?></p>

            <?php elseif ($p['type'] == 'li'): ?>
              <?php if (!isset($open_list) || !$open_list): ?>
                <ul>
                <?php $open_list = true; ?>
              <?php endif; ?>
              <li><?= htmlspecialchars($p['para_text']) ?></li>

            <?php elseif ($p['type'] == 'html'): ?>
              <?= $p['para_text'] ?>

            <?php endif; ?>

          <?php endforeach; ?>

          <?php if (isset($open_list) && $open_list): ?>
            </ul>
            <?php $open_list = false; ?>
          <?php endif; ?>

        <?php endif; ?>

      </div>
    <?php endforeach; ?>



    <!-- ✅ Booking Form (exactly same as your original static page) -->
    <div class="bg-white p-4 rounded shadow-sm mt-5">
      <h4 class="fw-bold greet-title mb-4 text-center">Event Booking Form</h4>

      <form>
        <div class="mb-3">
          <label>I have contacted the IAOS Office to confirm availability *</label>
          <select class="form-select">
            <option value="">Select</option>
            <option>Yes</option>
            <option>No</option>
          </select>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Your Name *</label>
            <input type="text" class="form-control" placeholder="First and Last Name">
          </div>
          <div class="col-md-6 mb-3">
            <label>Email *</label>
            <input type="email" class="form-control" placeholder="you@example.com">
          </div>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Phone *</label>
            <input type="text" class="form-control" placeholder="+255 0621 234 567">
          </div>
          <div class="col-md-6 mb-3">
            <label>Is IAOS hosting this event? *</label><br>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="hosting" value="yes">
              <label class="form-check-label">Yes</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="hosting" value="no">
              <label class="form-check-label">No</label>
            </div>
          </div>
        </div>

        <div class="mb-3">
          <label>Event Name *</label>
          <input type="text" class="form-control" placeholder="Event Title">
        </div>

        <div class="mb-3">
          <label>Person/Organization Responsible *</label>
          <input type="text" class="form-control" placeholder="Name or Organization">
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Date *</label>
            <input type="date" class="form-control">
          </div>
          <div class="col-md-6 mb-3">
            <label>Time *</label>
            <input type="time" class="form-control">
          </div>
        </div>

        <div class="mb-3">
          <label>Event Duration *</label>
          <input type="text" class="form-control" placeholder="e.g., 2 hours">
        </div>

        <div class="mb-3">
          <label>Event Type *</label>
          <input type="text" class="form-control" placeholder="Wedding, Community Meeting, etc.">
        </div>

        <div class="mb-3">
          <label>Brief Event Description *</label>
          <textarea class="form-control" rows="3"></textarea>
        </div>

        <hr>
        <h5 class="text-success mt-4 mb-3">Renting Options</h5>
        <p>Choose the space(s) you want to rent:</p>

        <div class="row mb-3">
          <div class="col-md-6">
            <div class="form-check"><input class="form-check-input" type="checkbox"> <label>Gym</label></div>
            <div class="form-check"><input class="form-check-input" type="checkbox"> <label>Kitchen</label></div>
            <div class="form-check"><input class="form-check-input" type="checkbox"> <label>Library</label></div>
          </div>
          <div class="col-md-6">
            <div class="form-check"><input class="form-check-input" type="checkbox"> <label>Upstairs Mezzanine</label></div>
            <div class="form-check"><input class="form-check-input" type="checkbox"> <label>Stage</label></div>
          </div>
        </div>

        <div class="mb-3">
          <label>Are you a current IAOS Member?</label><br>
          <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="member" value="yes"><label class="form-check-label">Yes</label></div>
          <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="member" value="no"><label class="form-check-label">No</label></div>
        </div>

        <hr>
        <h5 class="text-success mt-4 mb-3">Additional Items</h5>
        <p>Available for gym/kitchen renters. Please indicate if you require them:</p>

        <div class="row mb-3">
          <div class="col-md-4"><label>Chairs (max 260)</label><input type="number" class="form-control" min="0" max="260"></div>
          <div class="col-md-4"><label>Small Round Tables (max 17)</label><input type="number" class="form-control" min="0" max="17"></div>
          <div class="col-md-4"><label>Large Rectangular Tables (max 17)</label><input type="number" class="form-control" min="0" max="17"></div>
        </div>

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" value="stage">
          <label class="form-check-label">Stage Required (additional $30 fee)</label>
        </div>

        <hr>
        <div class="mb-3">
          <label>Affirmation *</label><br>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" required>
            <label class="form-check-label">I affirm that all provided information is accurate and agree to the policies.</label>
          </div>
        </div>

        <div class="mb-3">
          <label>Terms of Service *</label><br>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" required>
            <label class="form-check-label">I have read and agree with the Terms and Conditions.</label>
          </div>
        </div>

        <div class="text-center mt-4">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Booking</button>
        </div>

      </form>
    </div>

  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
