<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Sisters Quran Program | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <!-- Custom CSS -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner2.jpg') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Sisters Quran Program</h1>
    <p class="lead">IAOS Regina – Quran Learning, Tajweed & Islamic Studies for Sisters</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="about-section py-5">
  <div class="container-xl">

    <div class="mb-5 text-white">
      <h3 class="greet-title text-white greet-title-in fw-bold mb-3">PROGRAM OVERVIEW</h3>
      <p>The <strong>Sisters Quran Program</strong> at IAOS Regina is designed exclusively for women and sisters who wish to learn, recite, and understand the Holy Quran in a comfortable and spiritual environment. The classes focus on Quran reading, Tajweed, memorization, and understanding key Islamic principles that help strengthen faith and practice.</p>

      <h5 class="fw-bold text-success mt-4">Program Objectives:</h5>
      <ul>
        <li>To teach Quran recitation with correct pronunciation and Tajweed.</li>
        <li>To help sisters memorize selected Surahs and Duas.</li>
        <li>To provide a safe and supportive space for Islamic learning.</li>
        <li>To study basic Tafseer and gain understanding of Quranic meanings.</li>
        <li>To encourage building connection with Allah and consistency in recitation.</li>
      </ul>

      <h5 class="fw-bold text-success mt-4">Program Details:</h5>
      <ul>
        <li><strong>Academic Session:</strong> Ongoing (throughout the year)</li>
        <li><strong>Days:</strong> Tuesday & Thursday (Twice a week)</li>
        <li><strong>Time:</strong> 10:00 AM – 12:00 PM</li>
        <li><strong>Location:</strong> IAOS Masjid, 3273 Montague Street, Regina, SK</li>
        <li><strong>Eligibility:</strong> Open to all adult sisters (no age limit)</li>
        <li><strong>Monthly Fees:</strong> $40 per participant</li>
        <li><strong>Payment Method:</strong> EFT (Electronic Fund Transfer)</li>
      </ul>
    </div>

    <!-- ================= RULES ACCORDION ================= -->
    <div class="accordion mb-5" id="rulesAccordion">
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseRules">
            Rules and Guidelines
          </button>
        </h2>
        <div id="collapseRules" class="accordion-collapse collapse">
          <div class="accordion-body">
            <p><strong>Attendance:</strong> Regular attendance ensures steady progress. Please inform the teacher in case of absence.</p>
            <p><strong>Etiquette:</strong> Respect, kindness, and punctuality are expected from all participants.</p>
            <p><strong>Dress Code:</strong> Sisters should wear modest Islamic attire (Abaya/Hijab required).</p>
            <p><strong>Materials:</strong> Please bring your own Quran, notebook, and pen to each class.</p>
            <p><strong>Environment:</strong> Maintain silence and respect during Quran recitation and lectures.</p>
            <p><strong>Children:</strong> Childcare is not available. Please make arrangements before attending.</p>
            <p><strong>Financial Assistance:</strong> Available for sisters in need upon request and approval by IAOS administration.</p>
            <p><strong>Contact:</strong> <a href="mailto:schooladmin@iaosregina.com">schooladmin@iaosregina.com</a></p>
          </div>
        </div>
      </div>
    </div>

    <!-- ================= REGISTRATION FORM ================= -->
    <div class="bg-white p-4 rounded shadow-sm">
      <h4 class="fw-bold text-success mb-4 text-center">Sisters Quran Program Registration Form</h4>
      <p class="text-center mb-4">Please fill out the required information. Fields marked with * are mandatory.</p>

      <form>
        <div class="mb-3">
          <label>Email Address *</label>
          <input type="email" class="form-control" placeholder="e.g. alsaadi.ubaid@gmail.com" required>
        </div>

        <div class="mb-3">
          <label>Full Name *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Contact Number *</label>
            <input type="text" class="form-control" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Emergency Contact (Name & Phone) *</label>
            <input type="text" class="form-control" placeholder="e.g. Sidra Ubaid – 306-201-4008" required>
          </div>
        </div>

        <div class="mb-3">
          <label>Address *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="mb-3">
          <label>Preferred Level *</label>
          <select class="form-select" required>
            <option value="">Select Level</option>
            <option>Beginner (Basic Reading / Qaida)</option>
            <option>Intermediate (Fluent Reading + Tajweed)</option>
            <option>Advanced (Hifz / Tafseer / Revision)</option>
          </select>
        </div>

        <div class="mb-3">
          <label>Previous Quran Teacher / Institute (if any)</label>
          <input type="text" class="form-control" placeholder="Optional">
        </div>

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" id="agreeRules" required>
          <label class="form-check-label" for="agreeRules">
            I certify that I have read the <a href="#collapseRules" data-bs-toggle="collapse" class="text-success fw-semibold text-decoration-none">rules and guidelines</a> and will abide by them.
          </label>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-5 py-2">Submit Registration</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Our Mosque Locations</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <h5 class="text-success">IAOS (Regina) Mosque</h5>
        <p class="text-success">3273 Montague St, Regina, SK S4S 1Z8</p>
        <iframe src="https://www.google.com/maps?q=3273+Montague+St,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">As-Salam Mosque & Community Center</h5>
        <p class="text-success">641 Victoria Ave E, Regina, SK S4N 0P1</p>
        <iframe src="https://www.google.com/maps?q=641+Victoria+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
      <div class="col-md-4">
        <h5 class="text-success">East Musallah</h5>
        <p class="text-success">2318 Assiniboine Ave E, Regina, SK S4V 2P5</p>
        <iframe src="https://www.google.com/maps?q=2318+Assiniboine+Ave+E,+Regina,+SK&output=embed"></iframe>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY=window.scrollY;
const donateBtn=document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll',()=>{donateBtn.style.opacity=window.scrollY>lastScrollY?'0':'1';lastScrollY=window.scrollY;});
</script>
</body>
</html>
