<?php
ob_start();
require_once "admin_pannel/db.php";

function uploadFile($field, $folder) {
    if (empty($_FILES[$field]['name'])) return null;

    if (!is_dir($folder)) {
        mkdir($folder, 0775, true);
    }

    $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg','jpeg','png','pdf','doc','docx'];

    if (!in_array($ext, $allowed)) return null;

    $safeName = time() . "_" . preg_replace("/[^a-zA-Z0-9._-]/", "_", $_FILES[$field]['name']);
    $path = $folder . "/" . $safeName;

    if (move_uploaded_file($_FILES[$field]['tmp_name'], $path)) {
        return $path;
    }
    return null;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $immigration = uploadFile('immigration_doc', 'uploads/rizq/immigration');
    $bank        = uploadFile('bank_statement', 'uploads/rizq/bank');
    $housing     = uploadFile('rental_mortgage_doc', 'uploads/rizq/housing');

    $stmt = $pdo->prepare("
        INSERT INTO iaos_rizq_applications (
            first_name, last_name, mobile_phone, email,
            street_address, street_address_2, city, province, postal_code,
            birth_date, marital_status, gender,
            adults_18_plus, children_12_17, children_0_11,
            immigration_doc, bank_statement, rental_mortgage_doc,
            additional_information, liability_accept, signature_name
        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
    ");

    $stmt->execute([
        $_POST['first_name'],
        $_POST['last_name'],
        $_POST['mobile_phone'],
        $_POST['email'],

        $_POST['street_address'],
        $_POST['street_address_2'] ?? '',
        $_POST['city'],
        $_POST['province'],
        $_POST['postal_code'],

        $_POST['birth_date'],
        $_POST['marital_status'],
        $_POST['gender'],

        (int)$_POST['adults_18_plus'],
        (int)$_POST['children_12_17'],
        (int)$_POST['children_0_11'],

        $immigration,
        $bank,
        $housing,

        $_POST['additional_information'],
        $_POST['liability_accept'],
        $_POST['signature_name']
    ]);

    header("Location: rizq_success.php");
    exit;
}
