<?php
ob_start();
require_once "db.php";
$pdo = get_db();
header('Content-Type: application/json');

try {
    if (!isset($_POST['full_name'], $_POST['topic'], $_POST['appointment_date'], $_POST['appointment_time'])) {
        throw new Exception("Missing required fields.");
    }

    $stmt = $pdo->prepare("
        INSERT INTO imam_appointments (full_name, email, phone, topic, appointment_date, appointment_time, notes)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt->execute([
        $_POST['full_name'],
        $_POST['email'] ?? '',
        $_POST['phone'] ?? '',
        $_POST['topic'],
        $_POST['appointment_date'],
        $_POST['appointment_time'],
        $_POST['notes'] ?? ''
    ]);

    // Email notification to Imam
    $imam_email = "Alsaadi.ubaid@gmail.com";
    $subject = "New Appointment Request - " . $_POST['full_name'];
    $body = "
        <h3>New Appointment Request</h3>
        <p><strong>Name:</strong> {$_POST['full_name']}</p>
        <p><strong>Email:</strong> {$_POST['email']}</p>
        <p><strong>Phone:</strong> {$_POST['phone']}</p>
        <p><strong>Topic:</strong> {$_POST['topic']}</p>
        <p><strong>Date:</strong> {$_POST['appointment_date']}</p>
        <p><strong>Time:</strong> {$_POST['appointment_time']}</p>
        <p><strong>Notes:</strong> {$_POST['notes']}</p>
        <hr>
        <p>Please log in to the IAOS Control Panel to view all appointments.</p>
    ";

    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8\r\n";
    $headers .= "From: IAOS Appointments <noreply@iaos.org>\r\n";

    @mail($imam_email, $subject, $body, $headers);

    echo json_encode(["status"=>"success","message"=>"✅ Appointment booked successfully! Imam will contact you soon."]);
} catch (Exception $e) {
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
}
