<?php
ob_start();
require_once "db.php";

$pdo = get_db();

// ✅ Public question submission — no login required
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['full_name']) && !empty($_POST['question'])) {
    $stmt = $pdo->prepare("
        INSERT INTO imam_questions (full_name, email, phone, question, status, created_at)
        VALUES (?, ?, ?, ?, 'pending', NOW())
    ");
    $stmt->execute([
        $_POST['full_name'],
        $_POST['email'],
        $_POST['phone'],
        $_POST['question']
    ]);

    // ✅ Redirect to chat page
    $qid = $pdo->lastInsertId();
    header("Location: user_chat.php?id=$qid");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Ask the Imam | IAOS</title>

  <!-- ✅ Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(135deg, #052c07 0%, #0f5132 100%);
      min-height: 100vh;
      font-family: 'Segoe UI', sans-serif;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .card {
      width: 100%;
      max-width: 700px;
      border-radius: 18px;
      overflow: hidden;
      transition: all 0.3s ease;
    }

    .card:hover {
      transform: translateY(-4px);
      box-shadow: 0 0 25px rgba(0,0,0,0.35);
    }

    .card-header {
      background: #198754;
      text-align: center;
    }

    .card-header h4 {
      font-weight: 700;
    }

    .form-control {
      border-radius: 10px;
      font-size: 1rem;
    }

    .form-label {
      font-weight: 500;
    }

    .btn-success {
      border-radius: 10px;
      font-size: 1.1rem;
      font-weight: 600;
      box-shadow: 0 3px 0 rgba(0,0,0,0.2);
      transition: all 0.2s ease;
    }

    .btn-success:hover {
      background-color: #157347;
      transform: scale(1.02);
    }

    .btn-outline-light {
      border-radius: 10px;
      font-weight: 600;
      font-size: 1rem;
    }

    .footer {
      color: rgba(255,255,255,0.8);
      text-align: center;
      margin-top: 20px;
      font-size: 0.9rem;
    }

    .form-control::placeholder {
      color: #aaa;
      opacity: 0.8;
    }

    textarea.form-control {
      resize: none;
    }
  </style>
</head>

<body>

  <div class="card shadow-lg border-0">
    <div class="card-header text-white py-4">
      <h4><i class="bi bi-moon-stars-fill me-2"></i> Ask the Imam</h4>
      <small class="text-light">Submit your question or book a private appointment</small>
    </div>

    <div class="card-body bg-dark text-light p-4">

      <!-- ✅ Book Appointment Button -->
      <div class="text-center mb-4">
        <a href="book_appoiment.php"
           target="_blank"
           class="btn btn-outline-light btn-lg w-100">
          <i class="bi bi-calendar-plus me-2"></i> Book Appointment with Imam
        </a>
      </div>

      <form method="post" autocomplete="off">

        <div class="mb-3">
          <label class="form-label"><i class="bi bi-person-fill me-1"></i> Full Name</label>
          <input type="text" name="full_name" class="form-control" placeholder="Enter your full name" required>
        </div>

        <div class="mb-3">
          <label class="form-label"><i class="bi bi-envelope-fill me-1"></i> Email (optional)</label>
          <input type="email" name="email" class="form-control" placeholder="example@email.com">
        </div>

        <div class="mb-3">
          <label class="form-label"><i class="bi bi-telephone-fill me-1"></i> Phone (optional)</label>
          <input type="text" name="phone" class="form-control" placeholder="Enter your contact number">
        </div>

        <div class="mb-3">
          <label class="form-label"><i class="bi bi-chat-left-text-fill me-1"></i> Your Question</label>
          <textarea name="question" class="form-control" rows="5" placeholder="Write your question here..." required></textarea>
        </div>

        <button type="submit" class="btn btn-success w-100 py-2 mt-2">
          <i class="bi bi-send-fill me-1"></i> Submit Question
        </button>
      </form>
    </div>

    <div class="card-footer bg-success text-white text-center py-3">
      <small>© <?= date('Y') ?> IAOS — All Rights Reserved</small>
    </div>
  </div>

  <!-- ✅ Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    // ✅ Button loading animation
    const form = document.querySelector("form");
    form.addEventListener("submit", () => {
      const btn = form.querySelector("button");
      btn.disabled = true;
      btn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i> Submitting...';
    });
  </script>

</body>
</html>
