<?php
// db.php
// Centralized DB connection file. Public safe version (no login/session logic).

declare(strict_types=1);

error_reporting(0); // don't leak errors to clients
ini_set('display_errors', '0');

define('DB_HOST', 'localhost');
define('DB_NAME', 'iaosr874_new');
define('DB_USER', 'iaosr874_newWeb');
define('DB_PASS', 'kkrNvZVT57-ru3~]');
define('DB_CHARSET', 'utf8mb4');

/**
 * Return a PDO instance (singleton).
 * @return PDO
 */
function get_db(): PDO
{
    static $pdo = null;
    if ($pdo instanceof PDO) {
        return $pdo;
    }

    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        $pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_general_ci");
        $pdo->exec("SET CHARACTER SET utf8mb4");
        $pdo->exec("SET SESSION collation_connection = 'utf8mb4_general_ci'");
        return $pdo;
    } catch (PDOException $e) {
        http_response_code(500);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['error' => 'Database connection failed']);
        exit;
    }
}
?>
