<?php
ob_start();
include "layout.php";
require_once "db.php";

if (!in_array($role, ['admin', 'financeController'])) {
    die("Access denied.");
}

$pdo = get_db();
$year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');

// ---------------- FETCH DONATIONS (from new table donation) ----------------
$stmt = $pdo->prepare("
    SELECT DATE_FORMAT(donation_date, '%Y-%m') AS month, SUM(amount) AS total
    FROM donation
    WHERE YEAR(donation_date) = ?
    GROUP BY month ORDER BY month ASC
");
$stmt->execute([$year]);
$donationsData = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Prepare arrays for charts
$months = [];
$donations = [];

for ($i = 1; $i <= 12; $i++) {
    $month = sprintf('%04d-%02d', $year, $i);
    $months[] = date('M', strtotime($month . '-01'));
    $donationValue = 0;

    foreach ($donationsData as $d) {
        if ($d['month'] === $month) $donationValue = $d['total'];
    }

    $donations[] = round($donationValue, 2);
}

// Summary
$totalDonations = array_sum($donations);

// Donation categories
$donCatStmt = $pdo->query("
    SELECT c.category_name, SUM(d.amount) AS total 
    FROM donation_categories c 
    LEFT JOIN donation d ON d.category_id = c.id 
    GROUP BY c.id
");
$donCats = $donCatStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Finance Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0"></script>
<style>
body { background:#064635; color:white; padding:20px; font-family:sans-serif; }
.card { background:rgba(255,255,255,0.1); border:none; border-radius:15px; padding:20px; color:white; }
canvas { width:100%!important; height:100%!important; }
h5, h3, h4 { color:white; }
</style>
</head>
<body>

<div class="container-fluid" style="margin-top:50px;">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h3><i class="bi bi-cash-coin"></i> Finance Dashboard</h3>
    <form method="GET" class="d-flex">
      <select name="year" class="form-select me-2" onchange="this.form.submit()">
        <?php for ($y = date('Y'); $y >= date('Y') - 5; $y--): ?>
          <option value="<?= $y ?>" <?= $y==$year?'selected':'' ?>><?= $y ?></option>
        <?php endfor; ?>
      </select>
      <button class="btn btn-light"><i class="bi bi-search"></i></button>
    </form>
  </div>

  <!-- Summary Cards -->
  <div class="row text-center mb-4">
    <div class="col-md-12 mb-3">
      <div class="card">
        <h5>Total Donations (<?= $year ?>)</h5>
        <h3>$<?= number_format($totalDonations,2) ?></h3>
      </div>
    </div>
  </div>

  <div class="row">
    <!-- Main Donations Chart -->
    <div class="col-lg-8">
      <div class="card mb-4">
        <h5><i class="bi bi-graph-up-arrow"></i> Monthly Donations (<?= $year ?>)</h5>
        <canvas id="donationChart"></canvas>
      </div>
    </div>

    <!-- Right Side: Donations by Category -->
    <div class="col-lg-4">
      <div class="card">
        <h5><i class="bi bi-pie-chart"></i> Donations by Category</h5>
        <?php foreach($donCats as $index => $c): ?>
          <div class="my-3">
            <strong><?= htmlspecialchars($c['category_name']) ?></strong>
            <canvas id="donChart<?= $index ?>" style="height:100px;"></canvas>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>

<script>
// Main line chart
const ctx = document.getElementById('donationChart');
new Chart(ctx, {
  type: 'line',
  data: {
    labels: <?= json_encode($months) ?>,
    datasets: [
      { label: 'Donations', data: <?= json_encode($donations) ?>, borderColor: '#00ff80', backgroundColor: 'rgba(0,255,128,0.3)', fill:true }
    ]
  },
  options: {
    scales: { 
      y: { beginAtZero:true, ticks:{color:'white'} },
      x: { ticks:{color:'white'} }
    },
    plugins: { legend:{ labels:{color:'white'} } }
  }
});

// Category charts
<?php foreach($donCats as $index => $c): ?>
new Chart(document.getElementById('donChart<?= $index ?>'), {
  type: 'doughnut',
  data: {
    labels: ['<?= addslashes($c['category_name']) ?>', 'Other'],
    datasets: [{
      data: [<?= $c['total'] ?? 0 ?>, <?= max($totalDonations - ($c['total'] ?? 0), 0) ?>],
      backgroundColor: ['#0b7b4c', '#cfcfcf']
    }]
  },
  options: { plugins:{ legend:{display:false} }, cutout:'70%' }
});
<?php endforeach; ?>
</script>

</body>
</html>
