<?php
ob_start();
require_once "db.php"; // layout removed for clean redirect safety

session_start();
$role = $_SESSION['role'] ?? 'imamController'; // fallback

if (!in_array($role, ['admin', 'imamController'])) {
    echo "<div class='alert alert-danger mt-5 text-center'>❌ Access denied.</div>";
    exit;
}

$pdo = get_db();
$questionId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// ✅ Fetch question
$qStmt = $pdo->prepare("SELECT * FROM imam_questions WHERE id=?");
$qStmt->execute([$questionId]);
$question = $qStmt->fetch();

if (!$question) {
    echo "<div class='alert alert-danger mt-5 text-center'>❌ Invalid question ID</div>";
    exit;
}

// ✅ Reset unread count when Imam opens chat
$pdo->prepare("UPDATE imam_questions SET unread_count=0 WHERE id=?")->execute([$questionId]);

// ✅ Handle message send
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['message'])) {
    $msg = trim($_POST['message']);
    if ($msg !== '') {
        $stmt = $pdo->prepare("INSERT INTO imam_chat (question_id, sender, message, created_at) VALUES (?, 'imam', ?, NOW())");
        $stmt->execute([$questionId, $msg]);

        // 🔥 Increment unread count for user
        $pdo->prepare("UPDATE imam_questions SET unread_count = unread_count + 1 WHERE id=?")->execute([$questionId]);
    }

    // Redirect to avoid form re-post and blank screen
    header("Location: imam_chat.php?id=$questionId");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Imam Chat</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<style>
body {
  background: linear-gradient(135deg,#e8f5e9,#dcedc8);
  font-family: 'Segoe UI', sans-serif;
}
.chat-box {
  height: 60vh;
  overflow-y: auto;
  background: #f9f9f9;
  padding: 15px;
  border-radius: 10px;
  border: 1px solid #ddd;
}
.msg-user {
  background: #fff;
  border-radius: 10px;
  padding: 10px 15px;
  margin-bottom: 10px;
  max-width: 70%;
  word-wrap: break-word;
}
.msg-imam {
  background: #064635;
  color: #fff;
  border-radius: 10px;
  padding: 10px 15px;
  margin-bottom: 10px;
  margin-left: auto;
  max-width: 70%;
  word-wrap: break-word;
}
.question-box {
  background: #e0f3e0;
  border-left: 5px solid #198754;
  padding: 15px;
  margin-bottom: 15px;
  border-radius: 8px;
}
.answer-box {
  background: #064635;
  color: #fff;
  border-left: 5px solid #ffc107;
  padding: 15px;
  margin-bottom: 15px;
  border-radius: 8px;
}
textarea { border-radius: 10px; }
</style>
</head>
<body>

<div class="container mt-5">
  <div class="card shadow-lg">
    <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
      <h5><i class="bi bi-chat-dots-fill"></i> Chat with <?= htmlspecialchars($question['full_name']) ?></h5>
      <a href="imam_controller.php" class="btn btn-light btn-sm"><i class="bi bi-arrow-left"></i> Back</a>
    </div>

    <div class="card-body">
      <!-- Question -->
      <div class="question-box">
        <h6 class="text-success mb-1"><i class="bi bi-question-circle-fill"></i> Question:</h6>
        <p class="mb-0"><?= nl2br(htmlspecialchars($question['question'])) ?></p>
      </div>

      <!-- Imam main answer if exists -->
      <?php if (!empty($question['answer'])): ?>
      <div class="answer-box">
        <h6 class="text-warning mb-1"><i class="bi bi-chat-left-quote-fill"></i> Imam’s Answer:</h6>
        <p class="mb-0"><?= nl2br(htmlspecialchars($question['answer'])) ?></p>
      </div>
      <?php endif; ?>

      <!-- Chat messages -->
      <div id="chatBox" class="chat-box"></div>
    </div>

    <div class="card-footer bg-light">
      <form method="post" id="chatForm" class="d-flex">
        <textarea name="message" id="message" class="form-control me-2" rows="2" placeholder="Type a message..." required></textarea>
        <button class="btn btn-success"><i class="bi bi-send-fill"></i></button>
      </form>
    </div>
  </div>
</div>

<script>
function loadChat() {
  $.get('load_chat.php', {id: <?= $questionId ?>}, function(data){
    $('#chatBox').html(data);
    $('#chatBox').scrollTop($('#chatBox')[0].scrollHeight);
  });
}
loadChat();
setInterval(loadChat, 4000);
</script>

</body>
</html>
