<?php
ob_start();
header('Content-Type: application/json');

// -------------------- CONFIG --------------------
$host     = "localhost";
$user     = "u290827053_iaos";   // your DB username
$pass     = "YOUR_PASSWORD";     // change this
$dbname   = "u290827053_iaos";   // your DB name
$csv_file = __DIR__ . "/ExportedPrayerTimesCsv664.csv"; // CSV file path

// -------------------- CONNECT --------------------
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    die(json_encode(["error" => "Database connection failed: " . $conn->connect_error]));
}

// -------------------- CREATE TABLE --------------------
$sql = "CREATE TABLE IF NOT EXISTS prayer_times (
    id INT AUTO_INCREMENT PRIMARY KEY,
    prayer_date DATE NOT NULL,
    fajar_begins TIME,
    fajar TIME,
    sunrise TIME,
    zuhar_begins TIME,
    zuhar TIME,
    asar_begins TIME,
    asar TIME,
    sunset TIME,
    magrib_begins TIME,
    isha_begins TIME,
    isha TIME,
    jumah1 TIME NULL,
    jumah2 TIME NULL,
    jumah3 TIME NULL,
    jumah4 TIME NULL
)";
$conn->query($sql);

// -------------------- HANDLE ACTION --------------------
$action = isset($_GET['action']) ? $_GET['action'] : 'fetch';

if ($action === "import") {
    // -------------------- IMPORT CSV --------------------
    if (!file_exists($csv_file)) {
        die(json_encode(["error" => "CSV file not found: $csv_file"]));
    }

    $handle = fopen($csv_file, "r");
    fgetcsv($handle); // skip header
    $conn->query("TRUNCATE TABLE prayer_times");

    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
        $stmt = $conn->prepare("INSERT INTO prayer_times 
            (prayer_date, fajar_begins, fajar, sunrise, zuhar_begins, zuhar, 
             asar_begins, asar, sunset, magrib_begins, isha_begins, isha,
             jumah1, jumah2, jumah3, jumah4)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

        $stmt->bind_param(
            "ssssssssssssssss",
            $data[0], $data[1], $data[2], $data[3], $data[4], $data[5],
            $data[6], $data[7], $data[8], $data[9], $data[10], $data[11],
            $data[12], $data[13], $data[14], $data[15]
        );
        $stmt->execute();
    }
    fclose($handle);

    echo json_encode(["status" => "success", "message" => "CSV import completed successfully"]);
}
// -------------------- FETCH DATA --------------------
else if ($action === "fetch") {
    $date = isset($_GET['date']) ? $_GET['date'] : date("Y-m-d");

    $stmt = $conn->prepare("SELECT * FROM prayer_times WHERE prayer_date = ? LIMIT 1");
    $stmt->bind_param("s", $date);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo json_encode($result->fetch_assoc(), JSON_PRETTY_PRINT);
    } else {
        echo json_encode(["message" => "No data found for date $date"]);
    }
}

$conn->close();
?>
