<?php
ob_start();
session_start();
require_once "db.php";

// ✅ Role check — only admin or salahController can update
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'salahController'])) {
    die("Access denied.");
}

$pdo = get_db();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['prayer_date'])) {

    $count = count($_POST['prayer_date']);
    $updated = 0;

    for ($i = 0; $i < $count; $i++) {
        $stmt = $pdo->prepare("
            UPDATE prayer_times 
            SET fajar_begins = ?, fajar = ?, 
                zuhar_begins = ?, zuhar = ?, 
                asar_begins = ?, asar = ?, 
                magrib_begins = ?, 
                isha_begins = ?, isha = ?
            WHERE prayer_date = ?
        ");
        $stmt->execute([
            $_POST['fajar_begins'][$i],
            $_POST['fajar'][$i],
            $_POST['zuhar_begins'][$i],
            $_POST['zuhar'][$i],
            $_POST['asar_begins'][$i],
            $_POST['asar'][$i],
            $_POST['magrib_begins'][$i],
            $_POST['isha_begins'][$i],
            $_POST['isha'][$i],
            $_POST['prayer_date'][$i]
        ]);

        if ($stmt->rowCount() > 0) $updated++;
    }

    // ✅ Redirect back with a success flag
    header("Location: edit_salah.php?month=" . substr($_POST['prayer_date'][0], 0, 7) . "&status=success&count=$updated");
    exit;
} else {
    // ❌ No data posted
    header("Location: edit_salah.php?error=nodata");
    exit;
}
