<?php
ob_start();
require_once "db.php";

$pdo = get_db();
$questionId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// ✅ Fetch the main question
$qStmt = $pdo->prepare("SELECT * FROM imam_questions WHERE id=?");
$qStmt->execute([$questionId]);
$question = $qStmt->fetch();

if (!$question) {
    echo "<div class='alert alert-danger mt-5 text-center'>❌ Invalid or missing question ID.</div>";
    exit;
}

// ✅ Reset unread count when user opens the chat
$pdo->prepare("UPDATE imam_questions SET unread_count = 0 WHERE id=?")->execute([$questionId]);

// ✅ When the user sends a new message
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['message'])) {
    $msg = trim($_POST['message']);
    $stmt = $pdo->prepare("INSERT INTO imam_chat (question_id, sender, message, created_at) VALUES (?, 'user', ?, NOW())");
    $stmt->execute([$questionId, $msg]);

    // 🔥 Increment unread count for Imam
    $pdo->prepare("UPDATE imam_questions SET unread_count = unread_count + 1 WHERE id=?")->execute([$questionId]);

    header("Location: user_chat.php?id=$questionId");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Chat with Imam</title>

  <!-- ✅ Bootstrap + Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(135deg, #052c07 0%, #0f5132 100%);
      min-height: 100vh;
      font-family: 'Segoe UI', sans-serif;
      color: #fff;
    }
    .chat-container {
      max-width: 800px;
      margin: 40px auto;
    }
    .chat-box {
      height: 65vh;
      overflow-y: auto;
      background: #111;
      padding: 15px;
      border-radius: 10px;
      border: 1px solid rgba(255,255,255,0.1);
    }
    .msg-user {
      background: #198754;
      color: #fff;
      border-radius: 10px;
      padding: 10px 15px;
      margin: 8px 0;
      max-width: 70%;
      margin-left: auto;
      word-wrap: break-word;
    }
    .msg-imam {
      background: #333;
      color: #f1f1f1;
      border-radius: 10px;
      padding: 10px 15px;
      margin: 8px 0;
      max-width: 70%;
      margin-right: auto;
      word-wrap: break-word;
    }
    .question-header {
      background: rgba(255,255,255,0.1);
      padding: 15px;
      border-radius: 10px;
      margin-bottom: 20px;
    }
    textarea {
      border-radius: 10px;
    }
    .btn-success {
      border-radius: 10px;
    }
  </style>
</head>

<body>

<div class="chat-container">
  <div class="card shadow-lg border-0">
    <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
      <h5 class="mb-0"><i class="bi bi-chat-dots-fill me-2"></i> Chat with Imam</h5>
      <a href="ask_imam.php" class="btn btn-light btn-sm"><i class="bi bi-arrow-left"></i> Ask New Question</a>
    </div>

    <div class="card-body bg-dark text-light">
      <div class="question-header">
        <strong><i class="bi bi-person-fill"></i> <?= htmlspecialchars($question['full_name']) ?></strong><br>
        <small><i class="bi bi-clock-fill"></i> Asked on <?= htmlspecialchars($question['created_at']) ?></small>
        <hr class="text-secondary my-2">
        <p><i class="bi bi-question-circle-fill text-warning"></i> <?= nl2br(htmlspecialchars($question['question'])) ?></p>

        <?php if (!empty($question['answer'])): ?>
          <div class="bg-secondary p-3 rounded mt-3">
            <strong><i class="bi bi-chat-left-quote-fill text-warning"></i> Imam’s Answer:</strong>
            <p class="mb-0"><?= nl2br(htmlspecialchars($question['answer'])) ?></p>
          </div>
        <?php endif; ?>
      </div>

      <div id="chatBox" class="chat-box"></div>
    </div>

    <div class="card-footer bg-dark border-0">
      <form method="post" class="d-flex">
        <textarea name="message" class="form-control me-2" rows="2" placeholder="Type your message..." required></textarea>
        <button class="btn btn-success"><i class="bi bi-send-fill"></i></button>
      </form>
    </div>
  </div>
</div>

<!-- ✅ Bootstrap + jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
function loadChat() {
  $.get('load_chat.php', {id: <?= $questionId ?>}, function(data) {
    $('#chatBox').html(data);
    $('#chatBox').scrollTop($('#chatBox')[0].scrollHeight);
  });
}

loadChat();
setInterval(loadChat, 4000); // Auto-refresh every 4 seconds
</script>

</body>
</html>
