<?php
ob_start();
require_once "db.php";

// FETCH SETTINGS
$set = $pdo->query("SELECT * FROM iaos_mosque_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// FETCH HEADINGS
$heads = $pdo->query("SELECT * FROM iaos_mosque_headings ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// FETCH PARAGRAPHS GROUPED
$pp = $pdo->query("SELECT * FROM iaos_mosque_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($pp as $row) {
    $paras[$row['heading_id']][] = $row;
}

// FETCH GALLERY
$gallery = $pdo->query("SELECT * FROM iaos_mosque_gallery ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Mosque Project | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; border-bottom:1px solid #2f343a; text-decoration:none; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }
.small-note { font-size:.875rem; color:#6c757d; }
</style>
</head>
<body>

<div class="admin-wrapper">

<?php include "sidebar.php"; ?>

<div class="admin-content">

<h3 class="mb-4">⚙️ Manage New Mosque Project Page</h3>

<?php if(isset($_GET['saved'])): ?>
<div class="alert alert-success">✅ Saved successfully!</div>
<?php endif; ?>

<!-- PAGE HEADER -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Page Header</div>

  <form action="save_mosque.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="save_settings">

    <label class="fw-bold">Page Title</label>
    <input type="text" name="page_title" class="form-control mb-3" value="<?= htmlspecialchars($set['page_title']) ?>">

    <label class="fw-bold">Page Subtitle</label>
    <textarea name="page_subtitle" class="form-control mb-3"><?= htmlspecialchars($set['page_subtitle']) ?></textarea>

    <label class="fw-bold">Header Background Image</label>
    <input type="file" name="bg_image" class="form-control mb-2">

    <?php if(!empty($set['bg_image'])): ?>
      <img src="../<?= htmlspecialchars($set['bg_image']) ?>" style="max-width:240px;">
    <?php endif; ?>

    <button class="btn btn-primary mt-3">Save Header</button>
  </form>
</div>

<!-- PROGRESS TEXT -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">📊 Progress Section Text</div>

  <form action="save_mosque.php" method="POST">
    <input type="hidden" name="action" value="save_progress_text">

    <label class="fw-bold">Progress Heading</label>
    <input type="text" name="progress_heading" class="form-control mb-2" value="<?= htmlspecialchars($set['progress_heading']) ?>">

    <label class="fw-bold">Progress Subtext</label>
    <textarea name="progress_subtext" class="form-control mb-3"><?= htmlspecialchars($set['progress_subtext']) ?></textarea>

    <button class="btn btn-success">Save Text</button>
  </form>
</div>

<!-- GRAPH NUMBERS -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">📈 Graph Amounts</div>
  <form action="save_mosque.php" method="POST">
    <input type="hidden" name="action" value="save_graph">

    <label>Collected</label>
    <input type="number" name="collected" class="form-control mb-2" value="<?= $set['collected'] ?>">

    <label>Remaining</label>
    <input type="number" name="remaining" class="form-control mb-2" value="<?= $set['remaining'] ?>">

    <label>Total Cost</label>
    <input type="number" name="total" class="form-control mb-2" value="<?= $set['total'] ?>">

    <button class="btn btn-success mt-2">Save Graph</button>
  </form>
</div>

<!-- ADD HEADING -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">➕ Add New Heading</div>
  <form action="save_mosque.php" method="POST">
    <input type="hidden" name="action" value="add_heading">

    <label>Heading Text</label>
    <input type="text" name="heading_text" class="form-control mb-2" required>

    <button class="btn btn-primary">Add Heading</button>
  </form>
</div>

<!-- EXISTING HEADINGS + PARAGRAPHS -->
<?php foreach($heads as $h): ?>
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="d-flex justify-content-between">
    <div class="section-title">📘 <?= htmlspecialchars($h['heading_text']) ?></div>

    <form action="save_mosque.php" method="POST" onsubmit="return confirm('Delete this heading? All paragraphs will be removed.');">
      <input type="hidden" name="action" value="delete_heading">
      <input type="hidden" name="id" value="<?= $h['id'] ?>">
      <button class="btn btn-danger btn-sm">Delete</button>
    </form>
  </div>

  <!-- Add paragraph -->
  <form action="save_mosque.php" method="POST" class="mb-3">
    <input type="hidden" name="action" value="add_paragraph">
    <input type="hidden" name="heading_id" value="<?= $h['id'] ?>">

    <textarea name="para_text" class="form-control mb-2" required></textarea>
    <button class="btn btn-secondary btn-sm">Add Paragraph</button>
  </form>

  <!-- List paragraphs -->
  <?php if(!empty($paras[$h['id']])): ?>
    <?php foreach($paras[$h['id']] as $p): ?>
      <div class="border bg-white rounded p-3 mb-2">
        <form action="save_mosque.php" method="POST">
          <input type="hidden" name="action" value="update_paragraph">
          <input type="hidden" name="id" value="<?= $p['id'] ?>">

          <textarea name="para_text" class="form-control mb-2" required><?= htmlspecialchars($p['para_text']) ?></textarea>

          <button class="btn btn-success btn-sm">Update</button>

          <button class="btn btn-danger btn-sm float-end"
            formaction="save_mosque.php" name="action" value="delete_paragraph"
            onclick="return confirm('Delete this paragraph?')">Delete</button>
        </form>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>

</div>
<?php endforeach; ?>

<!-- GALLERY -->
<div class="card p-4 shadow-sm mb-4 section-card">
  <div class="section-title">🖼️ Construction Gallery</div>

  <form action="save_mosque.php" method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="add_gallery_image">
    <input type="file" name="gallery_image" required class="form-control mb-3">
    <button class="btn btn-success btn-sm">Upload Image</button>
  </form>

  <div class="row mt-3 g-3">
    <?php foreach($gallery as $g): ?>
      <div class="col-md-3 col-sm-4 col-6">
        <div class="border bg-white p-2 rounded text-center">
          <img src="../<?= htmlspecialchars($g['image_path']) ?>" class="img-fluid rounded mb-2">

          <form action="save_mosque.php" method="POST">
            <input type="hidden" name="action" value="delete_gallery_image">
            <input type="hidden" name="id" value="<?= $g['id'] ?>">

            <button class="btn btn-danger btn-sm w-100"
              onclick="return confirm('Delete this image?')">Delete</button>
          </form>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

</div>

</div>
</div>
</body>
</html>
