<?php
ob_start();
require_once "db.php";

// ----- FETCH SETTINGS -----
$set = $pdo->query("SELECT * FROM iaos_policies_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// If first time, seed a row
if (!$set) {
    $pdo->exec("INSERT INTO iaos_policies_settings 
        (id, page_title, page_subtitle, bg_image, about_heading) 
        VALUES 
        (1, 'IAOS Policies', 'Guiding documents and frameworks for IAOS operations and governance', 'images/banner4.jpg', 'About Our Policies')");

    $set = $pdo->query("SELECT * FROM iaos_policies_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
}

// ----- FETCH ABOUT PARAGRAPHS -----
$aboutParas = $pdo->query("SELECT * FROM iaos_policies_about_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// ----- FETCH HEADINGS -----
$heads = $pdo->query("SELECT * FROM iaos_policies_headings ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// ----- FETCH PARAGRAPHS -----
$pp = $pdo->query("SELECT * FROM iaos_policies_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($pp as $row) {
    $paras[$row['heading_id']][] = $row;
}

// ----- FETCH FILES -----
$files = $pdo->query("SELECT * FROM iaos_policies_files ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manage Policies | IAOS Admin</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f5f6fa; }
.admin-wrapper { display:flex; min-height:100vh; }
.admin-sidebar { width:250px; background:#212529; color:#fff; }
.admin-sidebar a { color:#ccc; padding:12px 20px; display:block; border-bottom:1px solid #2f343a; text-decoration:none; }
.admin-sidebar a:hover, .admin-sidebar a.active { background:#0d6efd; color:#fff; }
.admin-content { flex-grow:1; padding:30px; }
.section-card { border-radius:10px; }
.section-title { font-weight:700; font-size:1.3rem; margin-bottom:15px; }
.small-note { font-size:.875rem; color:#6c757d; }
</style>
</head>
<body>

<div class="admin-wrapper">
    <?php include "sidebar.php"; ?>

    <div class="admin-content">

        <h3 class="mb-4">⚙️ Manage Policies Page</h3>

        <?php if(isset($_GET['saved'])): ?>
            <div class="alert alert-success">✅ Saved successfully!</div>
        <?php endif; ?>

        <!-- PAGE HEADER -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">🖼️ Page Header</div>

            <form action="save_policies.php" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="save_settings">

                <label class="fw-bold mb-1">Page Title</label>
                <input type="text" name="page_title" class="form-control mb-3" value="<?= htmlspecialchars($set['page_title']) ?>" required>

                <label class="fw-bold mb-1">Page Subtitle</label>
                <textarea name="page_subtitle" class="form-control mb-3" required><?= htmlspecialchars($set['page_subtitle']) ?></textarea>

                <label class="fw-bold mb-1">Header Background Image</label>
                <input type="file" name="bg_image" class="form-control mb-2">
                <div class="small-note mb-2">If omitted, the current background remains.</div>

                <?php if (!empty($set['bg_image'])): ?>
                    <img src="../uploads/<?= htmlspecialchars($set['bg_image']) ?>" class="rounded" style="max-width:240px;">
                <?php endif; ?>

                <button class="btn btn-primary mt-3">Save Header</button>
            </form>
        </div>

        <!-- ABOUT SECTION -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">ℹ️ About Our Policies</div>

            <form action="save_policies.php" method="POST" class="mb-3">
                <input type="hidden" name="action" value="save_about_heading">
                <label class="fw-bold mb-1">About Heading</label>
                <input type="text" name="about_heading" class="form-control mb-2" value="<?= htmlspecialchars($set['about_heading']) ?>" required>
                <button class="btn btn-primary btn-sm">Save Heading</button>
            </form>

            <form action="save_policies.php" method="POST" class="mb-3">
                <input type="hidden" name="action" value="add_about_paragraph">
                <label class="fw-bold mb-1">Add New Paragraph</label>
                <textarea name="para_text" class="form-control mb-2" placeholder="Write paragraph..." required></textarea>
                <button class="btn btn-secondary btn-sm">Add Paragraph</button>
            </form>

            <?php foreach ($aboutParas as $ap): ?>
                <div class="bg-white border rounded p-3 mb-2">
                    <form action="save_policies.php" method="POST">
                        <input type="hidden" name="action" value="update_about_paragraph">
                        <input type="hidden" name="id" value="<?= $ap['id'] ?>">

                        <textarea name="para_text" class="form-control mb-2" required><?= htmlspecialchars($ap['para_text']) ?></textarea>

                        <button class="btn btn-success btn-sm">Update</button>

                        <button formaction="save_policies.php" name="action" value="delete_about_paragraph" onclick="return confirm('Delete this paragraph?')" class="btn btn-danger btn-sm float-end">
                            Delete
                        </button>
                    </form>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- ADD HEADING -->
        <div class="card p-4 shadow-sm mb-4 section-card">
            <div class="section-title">➕ Add New Heading</div>

            <form action="save_policies.php" method="POST">
                <input type="hidden" name="action" value="add_heading">

                <label class="fw-bold mb-1">Heading Text</label>
                <input type="text" name="heading_text" class="form-control mb-2" required>

                <button class="btn btn-success">Add Heading</button>
            </form>
        </div>

        <!-- HEADINGS + PARAGRAPHS -->
        <?php foreach ($heads as $h): ?>
            <div class="card p-4 shadow-sm mb-4 section-card">
                <div class="d-flex justify-content-between mb-3">
                    <div class="section-title">📘 <?= htmlspecialchars($h['heading_text']) ?></div>
                    <form action="save_policies.php" method="POST" onsubmit="return confirm('Delete this heading? This will also remove its paragraphs.');">
                        <input type="hidden" name="action" value="delete_heading">
                        <input type="hidden" name="id" value="<?= $h['id'] ?>">
                        <button class="btn btn-danger btn-sm">Delete</button>
                    </form>
                </div>

                <!-- Add paragraph -->
                <form action="save_policies.php" method="POST" class="mb-3">
                    <input type="hidden" name="action" value="add_paragraph">
                    <input type="hidden" name="heading_id" value="<?= $h['id'] ?>">

                    <label class="fw-bold mb-1">Add Paragraph</label>
                    <textarea name="para_text" class="form-control mb-2" required></textarea>
                    <button class="btn btn-secondary btn-sm">Add Paragraph</button>
                </form>

                <!-- List paragraphs -->
                <?php if (!empty($paras[$h['id']])): ?>
                    <?php foreach ($paras[$h['id']] as $p): ?>
                        <div class="bg-white border rounded p-3 mb-2">
                            <form action="save_policies.php" method="POST">
                                <input type="hidden" name="action" value="update_paragraph">
                                <input type="hidden" name="id" value="<?= $p['id'] ?>">

                                <textarea name="para_text" class="form-control mb-2" required><?= htmlspecialchars($p['para_text']) ?></textarea>

                                <button class="btn btn-success btn-sm">Update</button>

                                <button formaction="save_policies.php" name="action" value="delete_paragraph" onclick="return confirm('Delete this paragraph?')" class="btn btn-danger btn-sm float-end">
                                    Delete
                                </button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>

        <!-- FILES -->
        <div class="card p-4 shadow-sm section-card">
            <div class="section-title">📑 Policy Files</div>

            <!-- Add file -->
            <form action="save_policies.php" method="POST" enctype="multipart/form-data" class="mb-3">
                <input type="hidden" name="action" value="add_file">

                <label class="fw-bold">File Title</label>
                <input type="text" name="file_title" class="form-control mb-2" required>

                <label class="fw-bold">PDF File</label>
                <input type="file" name="file_pdf" class="form-control mb-2" accept="application/pdf" required>

                <button class="btn btn-success">Upload File</button>
            </form>

            <!-- List files -->
            <?php foreach ($files as $f): ?>
                <div class="p-3 bg-white border rounded mb-2">
                    <form action="save_policies.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="update_file">
                        <input type="hidden" name="id" value="<?= $f['id'] ?>">

                        <label class="fw-bold">File Title</label>
                        <input type="text" name="file_title" value="<?= htmlspecialchars($f['file_title']) ?>" class="form-control mb-2" required>

                        <label class="fw-bold">Replace File (optional)</label>
                        <input type="file" name="file_pdf" class="form-control mb-2" accept="application/pdf">

                        <div class="small-note mb-2">
                            Current File: 
                            <a href="../uploads/policies/<?= htmlspecialchars($f['file_name']) ?>" target="_blank">
                                <?= htmlspecialchars($f['file_name']) ?>
                            </a>
                        </div>

                        <button class="btn btn-success btn-sm">Update</button>

                        <button formaction="save_policies.php" name="action" value="delete_file" onclick="return confirm('Delete this file?')" class="btn btn-danger btn-sm float-end">
                            Delete
                        </button>
                    </form>
                </div>
            <?php endforeach; ?>
        </div>

    </div>
</div>

</body>
</html>
