<?php
ob_start();
require_once "db.php";

// ✅ Add slide
if (isset($_POST['add_slide'])) {
  $file = $_FILES['image'];
  $path = '';
  if ($file['error'] == UPLOAD_ERR_OK) {
    $path = "../images/" . basename($file['name']);
    move_uploaded_file($file['tmp_name'], $path);
    $path = "images/" . basename($file['name']);
  }
  $pdo->prepare("INSERT INTO hero_slides (title, subtitle, description, image, link, position)
                 VALUES (?,?,?,?,?,?)")
      ->execute([$_POST['title'], $_POST['subtitle'], $_POST['description'], $path, $_POST['link'], $_POST['position']]);
  header("Location: manage_headers.php");
  exit;
}

// ✅ Update slide
if (isset($_POST['update_slide'])) {
  $path = $_POST['old_image'];
  if (!empty($_FILES['image']['name'])) {
    $file = $_FILES['image'];
    $path = "images/" . basename($file['name']);
    move_uploaded_file($file['tmp_name'], "../" . $path);
  }
  $pdo->prepare("UPDATE hero_slides SET title=?, subtitle=?, description=?, image=?, link=?, position=? WHERE id=?")
      ->execute([$_POST['title'], $_POST['subtitle'], $_POST['description'], $path, $_POST['link'], $_POST['position'], $_POST['id']]);
  header("Location: manage_headers.php");
  exit;
}

// ✅ Delete slide
if (isset($_GET['delete'])) {
  $pdo->prepare("DELETE FROM hero_slides WHERE id=?")->execute([$_GET['delete']]);
  header("Location: manage_headers.php");
  exit;
}

// ✅ Fetch all slides
$slides = $pdo->query("SELECT * FROM hero_slides ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Headers | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
img.thumb{max-width:180px;border-radius:8px;}
</style>
</head>
<body>
<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">🖼 Manage Header Slides</h3>

    <form method="POST" enctype="multipart/form-data" class="card p-3 mb-4">
      <div class="row g-2">
        <div class="col-md-3"><input type="text" name="title" class="form-control" placeholder="Title"></div>
        <div class="col-md-3"><input type="text" name="subtitle" class="form-control" placeholder="Subtitle"></div>
        <div class="col-md-3"><input type="text" name="link" class="form-control" placeholder="Optional Link"></div>
        <div class="col-md-1"><input type="number" name="position" class="form-control" value="1"></div>
        <div class="col-md-2"><input type="file" name="image" class="form-control"></div>
        <div class="col-12 mt-2"><textarea name="description" rows="2" class="form-control" placeholder="Short Description"></textarea></div>
        <div class="col-12 mt-2 text-end"><button name="add_slide" class="btn btn-success">Add Slide</button></div>
      </div>
    </form>

    <table class="table table-bordered align-middle shadow-sm">
      <thead class="table-dark"><tr><th>ID</th><th>Image</th><th>Title</th><th>Subtitle</th><th>Position</th><th>Action</th></tr></thead>
      <tbody>
        <?php foreach($slides as $s): ?>
        <tr>
          <td><?= $s['id'] ?></td>
          <td><img src="../<?= $s['image'] ?>" class="thumb"></td>
          <td><?= htmlspecialchars($s['title']) ?></td>
          <td><?= htmlspecialchars($s['subtitle']) ?></td>
          <td><?= $s['position'] ?></td>
          <td>
            <button class="btn btn-primary btn-sm editBtn"
              data-id="<?= $s['id'] ?>"
              data-title="<?= htmlspecialchars($s['title']) ?>"
              data-subtitle="<?= htmlspecialchars($s['subtitle']) ?>"
              data-description="<?= htmlspecialchars($s['description']) ?>"
              data-link="<?= htmlspecialchars($s['link']) ?>"
              data-image="<?= $s['image'] ?>"
              data-position="<?= $s['position'] ?>">Edit</button>
            <a href="?delete=<?= $s['id'] ?>" onclick="return confirm('Delete?')" class="btn btn-danger btn-sm">Delete</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="POST" enctype="multipart/form-data">
        <div class="modal-header"><h5>Edit Slide</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body">
          <input type="hidden" name="id" id="editId">
          <input type="hidden" name="old_image" id="editOldImg">
          <label>Title</label><input name="title" id="editTitle" class="form-control mb-2">
          <label>Subtitle</label><input name="subtitle" id="editSubtitle" class="form-control mb-2">
          <label>Description</label><textarea name="description" id="editDesc" class="form-control mb-2"></textarea>
          <label>Link</label><input name="link" id="editLink" class="form-control mb-2">
          <label>Position</label><input name="position" id="editPos" type="number" class="form-control mb-2">
          <label>Image (1920x1080)</label><input type="file" name="image" class="form-control mb-2">
          <img id="editPreview" src="" class="thumb mt-2">
        </div>
        <div class="modal-footer"><button name="update_slide" class="btn btn-primary">Save</button><button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button></div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.querySelectorAll('.editBtn').forEach(b=>{
 b.onclick=()=>{
  editId.value=b.dataset.id;
  editTitle.value=b.dataset.title;
  editSubtitle.value=b.dataset.subtitle;
  editDesc.value=b.dataset.description;
  editLink.value=b.dataset.link;
  editPos.value=b.dataset.position;
  editOldImg.value=b.dataset.image;
  editPreview.src='../'+b.dataset.image;
  new bootstrap.Modal(editModal).show();
 }
});
</script>
</body>
</html>
