<?php
ob_start();
require_once "db.php";

// ✅ Add new item
if (isset($_POST['add'])) {
  $stmt = $pdo->prepare("INSERT INTO menu_items (parent_id, title, page_link, position, is_active) VALUES (?, ?, ?, ?, ?)");
  $stmt->execute([
    $_POST['parent_id'] ?: null,
    $_POST['title'],
    $_POST['page_link'],
    $_POST['position'],
    1
  ]);
  header("Location: manage_menu.php");
  exit;
}

// ✅ Update item
if (isset($_POST['update'])) {
  $stmt = $pdo->prepare("UPDATE menu_items SET parent_id=?, title=?, page_link=?, position=?, is_active=? WHERE id=?");
  $stmt->execute([
    $_POST['parent_id'] ?: null,
    $_POST['title'],
    $_POST['page_link'],
    $_POST['position'],
    isset($_POST['is_active']) ? 1 : 0,
    $_POST['id']
  ]);
  header("Location: manage_menu.php");
  exit;
}

// ✅ Delete
if (isset($_GET['delete'])) {
  $stmt = $pdo->prepare("DELETE FROM menu_items WHERE id=?");
  $stmt->execute([$_GET['delete']]);
  header("Location: manage_menu.php");
  exit;
}

// ✅ Fetch all
$stmt = $pdo->query("SELECT * FROM menu_items ORDER BY parent_id ASC, position ASC");
$menus = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Menu | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<style>
body {background:#f5f6fa;}
.admin-wrapper {display:flex;min-height:100vh;}
.admin-sidebar {width:250px;background:#212529;color:#fff;}
.admin-sidebar a {color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover {background:#0d6efd;color:#fff;}
.admin-content {flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">🧭 Manage Navigation Menu</h3>

    <!-- Add new -->
    <form method="POST" class="card p-4 mb-4 shadow-sm">
      <div class="row g-2">
        <div class="col-md-3">
          <label class="form-label">Parent Menu</label>
          <select name="parent_id" class="form-select">
            <option value="">Main Menu</option>
            <?php foreach ($menus as $m)
              if ($m['parent_id']==NULL)
                echo "<option value='{$m['id']}'>{$m['title']}</option>";
            ?>
          </select>
        </div>
        <div class="col-md-3"><label class="form-label">Title</label><input type="text" name="title" class="form-control" required></div>
        <div class="col-md-3"><label class="form-label">Page Link</label><input type="text" name="page_link" class="form-control" placeholder="about.php"></div>
        <div class="col-md-2"><label class="form-label">Position</label><input type="number" name="position" class="form-control" value="1"></div>
        <div class="col-md-1 d-flex align-items-end"><button name="add" class="btn btn-success w-100">Add</button></div>
      </div>
    </form>

    <!-- List -->
    <table class="table table-striped table-bordered align-middle shadow-sm">
      <thead class="table-dark">
        <tr><th>ID</th><th>Title</th><th>Parent</th><th>Link</th><th>Position</th><th>Active</th><th width="160">Action</th></tr>
      </thead>
      <tbody>
        <?php foreach ($menus as $item):
          $parentTitle='—';
          foreach($menus as $m2) if($m2['id']==$item['parent_id']) $parentTitle=$m2['title'];
        ?>
        <tr>
          <td><?= $item['id'] ?></td>
          <td><?= htmlspecialchars($item['title']) ?></td>
          <td><?= $parentTitle ?></td>
          <td><?= htmlspecialchars($item['page_link']) ?></td>
          <td><?= $item['position'] ?></td>
          <td><?= $item['is_active'] ? 'Yes':'No' ?></td>
          <td>
            <button class="btn btn-sm btn-primary editBtn"
              data-id="<?= $item['id'] ?>"
              data-title="<?= htmlspecialchars($item['title']) ?>"
              data-link="<?= htmlspecialchars($item['page_link']) ?>"
              data-position="<?= $item['position'] ?>"
              data-parent="<?= $item['parent_id'] ?>"
              data-active="<?= $item['is_active'] ?>">Edit</button>
            <a href="?delete=<?= $item['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this item?')">Delete</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="POST">
        <div class="modal-header"><h5>Edit Menu</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <div class="modal-body">
          <input type="hidden" name="id" id="editId">
          <div class="mb-3"><label>Parent</label>
            <select name="parent_id" id="editParent" class="form-select">
              <option value="">Main Menu</option>
              <?php foreach($menus as $m)
                if($m['parent_id']==NULL)
                  echo "<option value='{$m['id']}'>{$m['title']}</option>"; ?>
            </select></div>
          <div class="mb-3"><label>Title</label><input type="text" name="title" id="editTitle" class="form-control"></div>
          <div class="mb-3"><label>Page Link</label><input type="text" name="page_link" id="editLink" class="form-control"></div>
          <div class="mb-3"><label>Position</label><input type="number" name="position" id="editPosition" class="form-control"></div>
          <div class="form-check"><input type="checkbox" name="is_active" id="editActive" class="form-check-input"><label class="form-check-label" for="editActive">Active</label></div>
        </div>
        <div class="modal-footer"><button type="submit" name="update" class="btn btn-primary">Save</button><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button></div>
      </form>
    </div>
  </div>
</div>

<script>
document.querySelectorAll('.editBtn').forEach(b=>{
 b.onclick=()=>{
  editId.value=b.dataset.id;
  editTitle.value=b.dataset.title;
  editLink.value=b.dataset.link;
  editPosition.value=b.dataset.position;
  editParent.value=b.dataset.parent||"";
  editActive.checked=b.dataset.active==1;
  new bootstrap.Modal(editModal).show();
 }
});
</script>
</body>
</html>
