<?php
ob_start();
require_once "db.php";

// Add poster
if(isset($_POST['add_poster'])){
  $path="";
  if($_FILES['image']['error']==UPLOAD_ERR_OK){
    $path="images/".basename($_FILES['image']['name']);
    move_uploaded_file($_FILES['image']['tmp_name'],"../".$path);
  }
  $pdo->prepare("INSERT INTO posters(image,link,position) VALUES(?,?,?)")
      ->execute([$path,$_POST['link'],$_POST['position']]);
  header("Location: manage_posters.php");
  exit;
}

// Delete
if(isset($_GET['delete'])){
  $pdo->prepare("DELETE FROM posters WHERE id=?")->execute([$_GET['delete']]);
  header("Location: manage_posters.php");
  exit;
}

$posters=$pdo->query("SELECT * FROM posters ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8"><title>Manage Posters | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
img.thumb{max-width:200px;border-radius:8px;}
</style>
</head>
<body>
<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">🖼 Manage Posters</h3>

    <form method="POST" enctype="multipart/form-data" class="card p-3 mb-4">
      <div class="row g-2">
        <div class="col-md-5"><input type="file" name="image" class="form-control" required></div>
        <div class="col-md-5"><input type="text" name="link" class="form-control" placeholder="Link (optional)"></div>
        <div class="col-md-1"><input type="number" name="position" class="form-control" value="1"></div>
        <div class="col-md-1"><button name="add_poster" class="btn btn-success w-100">Add</button></div>
      </div>
    </form>

    <table class="table table-bordered align-middle shadow-sm">
      <thead class="table-dark"><tr><th>ID</th><th>Image</th><th>Link</th><th>Pos</th><th>Action</th></tr></thead>
      <tbody>
        <?php foreach($posters as $p): ?>
        <tr>
          <td><?= $p['id'] ?></td>
          <td><img src="../<?= $p['image'] ?>" class="thumb"></td>
          <td><?= htmlspecialchars($p['link']) ?></td>
          <td><?= $p['position'] ?></td>
          <td><a href="?delete=<?= $p['id'] ?>" onclick="return confirm('Delete poster?')" class="btn btn-danger btn-sm">Delete</a></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
