<?php
ob_start();
require_once "db.php";

// ✅ Add new message
if (isset($_POST['add'])) {
  $stmt = $pdo->prepare("INSERT INTO scrolling_news (message, position) VALUES (?, ?)");
  $stmt->execute([$_POST['message'], $_POST['position']]);
  header("Location: manage_scrolling_news.php?saved=1");
  exit;
}

// ✅ Update message
if (isset($_POST['update'])) {
  $stmt = $pdo->prepare("UPDATE scrolling_news SET message=?, position=? WHERE id=?");
  $stmt->execute([$_POST['message'], $_POST['position'], $_POST['id']]);
  header("Location: manage_scrolling_news.php?saved=1");
  exit;
}

// ✅ Delete message
if (isset($_GET['delete'])) {
  $pdo->prepare("DELETE FROM scrolling_news WHERE id=?")->execute([$_GET['delete']]);
  header("Location: manage_scrolling_news.php");
  exit;
}

// ✅ Fetch all
$newsList = $pdo->query("SELECT * FROM scrolling_news ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Manage Scrolling News | IAOS Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f6fa;}
.admin-wrapper{display:flex;min-height:100vh;}
.admin-sidebar{width:250px;background:#212529;color:#fff;}
.admin-sidebar a{color:#ccc;text-decoration:none;display:block;padding:12px 20px;}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#0d6efd;color:#fff;}
.admin-content{flex-grow:1;padding:30px;}
</style>
</head>
<body>

<div class="admin-wrapper">
  <?php include "sidebar.php"; ?>

  <div class="admin-content">
    <h3 class="mb-4">📰 Manage Scrolling News Bar</h3>
    <?php if(isset($_GET['saved'])): ?>
      <div class="alert alert-success">✅ Changes saved successfully!</div>
    <?php endif; ?>

    <!-- Add New -->
    <form method="POST" class="card p-4 mb-4 shadow-sm">
      <div class="row g-2 align-items-center">
        <div class="col-md-9">
          <label class="form-label">Message</label>
          <input type="text" name="message" class="form-control" placeholder="Enter message text" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">Position</label>
          <input type="number" name="position" class="form-control" value="1">
        </div>
        <div class="col-md-1 d-flex align-items-end">
          <button type="submit" name="add" class="btn btn-success w-100">Add</button>
        </div>
      </div>
    </form>

    <!-- List -->
    <table class="table table-bordered table-striped align-middle shadow-sm">
      <thead class="table-dark">
        <tr><th>ID</th><th>Message</th><th>Position</th><th width="150">Action</th></tr>
      </thead>
      <tbody>
        <?php foreach($newsList as $n): ?>
          <tr>
            <td><?= $n['id'] ?></td>
            <td><?= htmlspecialchars($n['message']) ?></td>
            <td><?= $n['position'] ?></td>
            <td>
              <button class="btn btn-sm btn-primary editBtn"
                data-id="<?= $n['id'] ?>"
                data-message="<?= htmlspecialchars($n['message']) ?>"
                data-position="<?= $n['position'] ?>"
              >Edit</button>
              <a href="?delete=<?= $n['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this item?')">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="POST">
        <div class="modal-header">
          <h5 class="modal-title">Edit News Message</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="editId">
          <div class="mb-3">
            <label class="form-label">Message</label>
            <input type="text" name="message" id="editMessage" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Position</label>
            <input type="number" name="position" id="editPosition" class="form-control" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="update" class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.querySelectorAll('.editBtn').forEach(btn=>{
  btn.addEventListener('click',()=>{
    document.getElementById('editId').value = btn.dataset.id;
    document.getElementById('editMessage').value = btn.dataset.message;
    document.getElementById('editPosition').value = btn.dataset.position;
    new bootstrap.Modal(document.getElementById('editModal')).show();
  });
});
</script>

</body>
</html>
