<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

/* =====================================================
   HELPER: IMAGE UPLOAD (SAME STYLE AS OTHER IAOS PAGES)
   - Disk: ../uploads/mosques/
   - DB  : uploads/mosques/filename.jpg
===================================================== */
function upload_header_image($field)
{
    if (empty($_FILES[$field]['name'])) {
        return null;
    }

    $allowed = ['jpg', 'jpeg', 'png', 'webp'];
    $ext = strtolower(pathinfo($_FILES[$field]['name'], PATHINFO_EXTENSION));

    if (!in_array($ext, $allowed)) {
        return null;
    }

    $diskDir = "../uploads/mosques";
    if (!is_dir($diskDir)) {
        mkdir($diskDir, 0775, true);
    }

    $safeName = preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $_FILES[$field]['name']);
    $filename = "header_" . time() . "_" . $safeName;

    $diskPath = $diskDir . "/" . $filename;
    $dbPath   = "uploads/mosques/" . $filename; // ✅ store without ../

    if (move_uploaded_file($_FILES[$field]['tmp_name'], $diskPath)) {
        return $dbPath;
    }

    return null;
}

/* -------------------------------------------------------------------
 ✅ 1. SAVE PAGE HEADER
-------------------------------------------------------------------- */
if ($action === "save_header") {

    $title    = trim($_POST['page_title']);
    $subtitle = trim($_POST['page_subtitle']);

    // Fetch current header image
    $stmt = $pdo->prepare("SELECT bg_image FROM mosque_page_settings WHERE id=1");
    $stmt->execute();
    $bg = $stmt->fetchColumn();

    // Upload new image if exists
    $newBg = upload_header_image('bg_image');
    if ($newBg) {
        // delete old image (optional but clean)
        if (!empty($bg) && is_file("../" . $bg)) {
            @unlink("../" . $bg);
        }
        $bg = $newBg;
    }

    $pdo->prepare("
        UPDATE mosque_page_settings
        SET page_title=?, page_subtitle=?, bg_image=?
        WHERE id=1
    ")->execute([$title, $subtitle, $bg]);

    header("Location: admin_mosques.php?saved=1");
    exit;
}

/* -------------------------------------------------------------------
 ✅ 2. ADD NEW MOSQUE
-------------------------------------------------------------------- */
if ($action === "add") {

    $pdo->prepare("
        INSERT INTO mosques
        (type, position, show_prayer_button, name, address, map_embed, website)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ")->execute([
        $_POST['type'],
        (int)$_POST['position'],
        (int)$_POST['show_prayer_button'],
        trim($_POST['name']),
        trim($_POST['address']),
        trim($_POST['map_embed']),
        trim($_POST['website']) ?: null
    ]);

    header("Location: admin_mosques.php?saved=1");
    exit;
}

/* -------------------------------------------------------------------
 ✅ 3. UPDATE MOSQUE
-------------------------------------------------------------------- */
if ($action === "update") {

    $pdo->prepare("
        UPDATE mosques SET
            name=?,
            position=?,
            show_prayer_button=?,
            address=?,
            map_embed=?,
            website=?
        WHERE id=?
    ")->execute([
        trim($_POST['name']),
        (int)$_POST['position'],
        (int)($_POST['show_prayer_button'] ?? 0),
        trim($_POST['address']),
        trim($_POST['map_embed']),
        trim($_POST['website']) ?: null,
        (int)$_POST['id']
    ]);

    header("Location: admin_mosques.php?saved=1");
    exit;
}

/* -------------------------------------------------------------------
 ✅ 4. DELETE MOSQUE
-------------------------------------------------------------------- */
if ($action === "delete") {

    $pdo->prepare("DELETE FROM mosques WHERE id=?")
        ->execute([(int)$_POST['id']]);

    header("Location: admin_mosques.php?saved=1");
    exit;
}

/* -------------------------------------------------------------------
 ❌ FALLBACK
-------------------------------------------------------------------- */
header("Location: admin_mosques.php?error=1");
exit;
