<?php
ob_start();
require_once "db.php";

if (!isset($_POST['action'])) {
    header("Location: admin_facility.php");
    exit;
}

$action = $_POST['action'];


/* ======================================================
   SAVE PAGE HEADER
======================================================*/
if ($action == "save_header") {

    $page_title = $_POST['page_title'];
    $page_subtitle = $_POST['page_subtitle'];

    // Default image path (keep existing if no upload)
    $bg_path = $settings['bg_image'];

    if (!empty($_FILES['bg_image']['name'])) {
        $upload_dir = "../images/";
        $file_name = "facility_" . time() . "_" . basename($_FILES['bg_image']['name']);
        $target_file = $upload_dir . $file_name;

        if (move_uploaded_file($_FILES['bg_image']['tmp_name'], $target_file)) {
            // Save relative path in DB
            $bg_path = "images/" . $file_name;
        }
    }

    $stmt = $pdo->prepare("UPDATE facility_page_settings SET 
        page_title=?, 
        page_subtitle=?, 
        bg_image=?
        WHERE id=1
    ");

    $stmt->execute([$page_title, $page_subtitle, $bg_path]);

    header("Location: admin_facility.php?saved=1");
    exit;
}



/* ======================================================
   ADD SECTION
======================================================*/
if ($action === "add_section") {

    $stmt = $pdo->prepare("
        INSERT INTO facility_sections (section_title, position)
        VALUES (?, ?)
    ");
    $stmt->execute([
        $_POST['section_title'],
        $_POST['position']
    ]);

    header("Location: admin_facility.php?saved=1");
    exit;
}



/* ======================================================
   UPDATE SECTION
======================================================*/
if ($action === "update_section") {

    $stmt = $pdo->prepare("
        UPDATE facility_sections 
        SET section_title=?, position=? 
        WHERE id=?
    ");
    $stmt->execute([
        $_POST['section_title'],
        $_POST['position'],
        $_POST['id']
    ]);

    header("Location: admin_facility.php?saved=1");
    exit;
}



/* ======================================================
   DELETE SECTION (CASCADE deletes paragraphs)
======================================================*/
if ($action === "delete_section") {

    $stmt = $pdo->prepare("DELETE FROM facility_sections WHERE id=?");
    $stmt->execute([ $_POST['id'] ]);

    header("Location: admin_facility.php?saved=1");
    exit;
}



/* ======================================================
   ADD PARAGRAPH
======================================================*/
if ($action === "add_paragraph") {

    $stmt = $pdo->prepare("
        INSERT INTO facility_paragraphs (section_id, type, para_text, position)
        VALUES (?, ?, ?, ?)
    ");

    $stmt->execute([
        $_POST['section_id'],
        $_POST['type'],
        $_POST['para_text'],
        $_POST['position']
    ]);

    header("Location: admin_facility.php?saved=1");
    exit;
}



/* ======================================================
   UPDATE PARAGRAPH
======================================================*/
if ($action === "update_paragraph") {

    $stmt = $pdo->prepare("
        UPDATE facility_paragraphs 
        SET type=?, para_text=?, position=? 
        WHERE id=?
    ");

    $stmt->execute([
        $_POST['type'],
        $_POST['para_text'],
        $_POST['position'],
        $_POST['id']
    ]);

    header("Location: admin_facility.php?saved=1");
    exit;
}



/* ======================================================
   DELETE PARAGRAPH
======================================================*/
if ($action === "delete_paragraph") {

    $stmt = $pdo->prepare("DELETE FROM facility_paragraphs WHERE id=?");
    $stmt->execute([ $_POST['id'] ]);

    header("Location: admin_facility.php?saved=1");
    exit;
}



/* ======================================================
   DEFAULT FALLBACK
======================================================*/
header("Location: admin_facility.php");
exit;
?>
