<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';

function safeFilename($name) {
  $name = preg_replace('/[^a-zA-Z0-9._-]/','_', $name);
  return $name ?: ('file_'.time());
}

/* UPDATE HEADER */
if ($action === "update_header") {
  $title = $_POST['page_title'] ?? '';
  $subtitle = $_POST['page_subtitle'] ?? '';

  $old = $pdo->query("SELECT bg_image FROM marriage_page_settings WHERE id=1")->fetchColumn();
  $image = $old;

  if (!empty($_FILES['bg_image']['name'])) {
    $base = time() . "_" . safeFilename($_FILES['bg_image']['name']);
    $serverPath = "../images/" . $base;     // physical file path
    $dbPath     = "images/" . $base;        // DB path (what frontend uses)
    if (move_uploaded_file($_FILES['bg_image']['tmp_name'], $serverPath)) {
      $image = $dbPath;
    }
  }

  $stm = $pdo->prepare("UPDATE marriage_page_settings SET page_title=?, page_subtitle=?, bg_image=? WHERE id=1");
  $stm->execute([$title, $subtitle, $image]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* ADD SECTION */
if ($action === "add_section") {
  $title = $_POST['section_title'] ?? '';
  $style = $_POST['style'] ?? 'green';
  $pdo->prepare("INSERT INTO marriage_sections (section_title, style, position) VALUES (?,?,?)")
      ->execute([$title, $style, time()]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* UPDATE SECTION */
if ($action === "update_section") {
  $id = (int)$_POST['id'];
  $title = $_POST['section_title'] ?? '';
  $style = $_POST['style'] ?? 'green';
  $pdo->prepare("UPDATE marriage_sections SET section_title=?, style=? WHERE id=?")
      ->execute([$title, $style, $id]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* DELETE SECTION */
if ($action === "delete_section") {
  $id = (int)$_POST['id'];
  // paragraphs have FK ON DELETE CASCADE
  $pdo->prepare("DELETE FROM marriage_sections WHERE id=?")->execute([$id]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* ADD PARAGRAPH */
if ($action === "add_para") {
  $section_id = (int)$_POST['section_id'];
  $text = $_POST['para_text'] ?? '';
  $type = $_POST['type'] ?? 'paragraph';
  $pdo->prepare("INSERT INTO marriage_paragraphs (section_id, para_text, type, position) VALUES (?,?,?,?)")
      ->execute([$section_id, $text, $type, time()]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* UPDATE PARAGRAPH */
if ($action === "update_para") {
  $id = (int)$_POST['id'];
  $text = $_POST['para_text'] ?? '';
  $type = $_POST['type'] ?? 'paragraph';
  $pdo->prepare("UPDATE marriage_paragraphs SET para_text=?, type=? WHERE id=?")
      ->execute([$text, $type, $id]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* DELETE PARAGRAPH */
if ($action === "delete_para") {
  $id = (int)$_POST['id'];
  $pdo->prepare("DELETE FROM marriage_paragraphs WHERE id=?")->execute([$id]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* ADD OFFICIAL */
if ($action === "add_official") {
  $name = $_POST['name'] ?? '';
  $phone = $_POST['phone'] ?? '';
  $pdo->prepare("INSERT INTO marriage_officials (name, phone, position) VALUES (?,?,?)")
      ->execute([$name, $phone, time()]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* UPDATE OFFICIAL */
if ($action === "update_official") {
  $id = (int)$_POST['id'];
  $name = $_POST['name'] ?? '';
  $phone = $_POST['phone'] ?? '';
  $pdo->prepare("UPDATE marriage_officials SET name=?, phone=? WHERE id=?")
      ->execute([$name, $phone, $id]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

/* DELETE OFFICIAL */
if ($action === "delete_official") {
  $id = (int)$_POST['id'];
  $pdo->prepare("DELETE FROM marriage_officials WHERE id=?")->execute([$id]);
  header("Location: admin_marriage.php?saved=1");
  exit;
}

header("Location: admin_marriage.php");
