<?php
ob_start();
require_once "db.php";

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;

/* ✅ Handle Thumbnail Upload */
function uploadThumbnail($fileKey) {
    if (!empty($_FILES[$fileKey]['name'])) {

        $ext = strtolower(pathinfo($_FILES[$fileKey]['name'], PATHINFO_EXTENSION));
        if (!in_array($ext, ['jpg','jpeg','png','webp'])) return null;

        // ✅ unique file name
        $fileName = time() . "_" . basename($_FILES[$fileKey]['name']);

        // ✅ full server location
        $serverPath = "../images/" . $fileName;

        // ✅ path stored in DB
        $dbPath = "images/" . $fileName;

        move_uploaded_file($_FILES[$fileKey]['tmp_name'], $serverPath);

        return $dbPath;
    }
    return null;
}

/* ✅ ADD VIDEO */
if ($action === "add") {

    $thumb = uploadThumbnail('thumbnail');

    $stmt = $pdo->prepare("
        INSERT INTO iaos_videos (title, youtube_url, thumbnail)
        VALUES (?, ?, ?)
    ");
    $stmt->execute([
        $_POST['title'],
        $_POST['youtube_url'],
        $thumb
    ]);

    header("Location: admin_videos.php?added=1");
    exit;
}

/* ✅ UPDATE VIDEO */
if ($action === "update") {

    $thumb = uploadThumbnail('thumbnail');

    if ($thumb) {
        $stmt = $pdo->prepare("
            UPDATE iaos_videos 
            SET title=?, youtube_url=?, thumbnail=? 
            WHERE id=?
        ");
        $stmt->execute([
            $_POST['title'],
            $_POST['youtube_url'],
            $thumb,
            $id
        ]);

    } else {
        $stmt = $pdo->prepare("
            UPDATE iaos_videos 
            SET title=?, youtube_url=? 
            WHERE id=?
        ");
        $stmt->execute([
            $_POST['title'],
            $_POST['youtube_url'],
            $id
        ]);
    }

    header("Location: admin_videos.php?updated=1");
    exit;
}

/* ✅ DELETE VIDEO */
if ($action === "delete") {

    $stmt = $pdo->prepare("DELETE FROM iaos_videos WHERE id=?");
    $stmt->execute([$id]);

    header("Location: admin_videos.php?deleted=1");
    exit;
}

?>
