<?php
require_once "admin_pannel/db.php";

$settings = $pdo->query("SELECT * FROM mosque_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

// Load main & other mosques
$main = $pdo->prepare("SELECT * FROM mosques WHERE type='main' ORDER BY position ASC");
$main->execute();
$mainMosques = $main->fetchAll(PDO::FETCH_ASSOC);

$other = $pdo->prepare("SELECT * FROM mosques WHERE type='other' ORDER BY position ASC");
$other->execute();
$otherMosques = $other->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title><?= htmlspecialchars($settings['page_title'] ?? 'Mosque Locations in Regina') ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="css/style.css" rel="stylesheet">

<link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>
    
<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="page-header text-center text-white py-5"
  style="background:url('<?= $settings['bg_image'] ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-3"><?= htmlspecialchars($settings['page_title']) ?></h1>
    <p class="lead fst-italic"><?= htmlspecialchars($settings['page_subtitle']) ?></p>
  </div>
</section>

<!-- MAIN MOSQUES -->
<section class="py-5">
  <div class="container-xl">
    <h2 class="text-center text-white greet-title fw-bold mb-5">Our Mosque Locations</h2>

    <div class="row g-4">

      <?php foreach ($mainMosques as $m): ?>
        <div class="col-md-4 text-center text-white">

          <h5 class="text-warning"><?= htmlspecialchars($m['name']) ?></h5>

          <p><?= htmlspecialchars($m['address']) ?></p>

          <iframe src="<?= htmlspecialchars($m['map_embed']) ?>"></iframe>


        </div>
      <?php endforeach; ?>

    </div>

    <hr class="my-5">
  </div>
</section>

<!-- OTHER MOSQUES -->
<section class="bg-light py-5">
  <div class="container-xl">
    <h2 class="text-center greet-title fw-bold mb-5">Other Mosques & Musalla Locations</h2>

    <div class="row g-4">

      <?php foreach ($otherMosques as $o): ?>
        <div class="col-md-4 text-center">

          <h5 class="text-success"><?= htmlspecialchars($o['name']) ?></h5>

          <p class="text-success"><?= htmlspecialchars($o['address']) ?></p>

          <iframe src="<?= htmlspecialchars($o['map_embed']) ?>"></iframe>

         

        </div>
      <?php endforeach; ?>

    </div>

    <hr class="my-5">
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
