<?php
require_once "admin_pannel/db.php";

/* SETTINGS */
$set = $pdo->query("SELECT * FROM iaos_contact_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* DATA */
$cats = $pdo->query("SELECT * FROM iaos_contact_categories WHERE is_active=1 ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);
$locs = $pdo->query("SELECT * FROM iaos_contact_locations WHERE is_active=1 ORDER BY position ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);

function esc($s){ return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= esc($set['page_title'] ?? 'Contact Us') ?> | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- ================= NAVBAR ================= -->
<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('<?= esc($set['bg_image'] ?: 'images/banner5.jpg') ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= esc($set['page_title'] ?? 'Contact Us') ?></h1>
    <p class="lead"><?= esc($set['page_subtitle'] ?? "We’d love to hear from you — whether you have a question, feedback, or a request.") ?></p>
  </div>
</section>

<!-- ================= INTRO (same as your News Updates style) ================= -->
<section class="py-5">
  <div class="container-xl">
    <div class="mb-5 text-white">
      <h3 class="greet-title fw-bold mb-3 greet-title-in text-white"><?= esc($set['intro_heading'] ?? 'Contact') ?></h3>
      <p><?= nl2br(esc($set['intro_text'] ?? '')) ?></p>
    </div>
  </div>
</section>

<!-- ================= CATEGORIES ================= -->
<section class="py-3">
  <div class="container-xl">

    <!-- Desktop Grid (visible md and up) -->
    <div class="row g-4 justify-content-center d-none d-md-flex">
      <?php if(empty($cats)): ?>
        <div class="col-12 text-center text-white-50">Categories will appear here once available.</div>
      <?php else: ?>
        <?php foreach ($cats as $cat): ?>
          <div class="col-md-3 col-sm-6">
            <div class="category-card">
              <h5><?= esc($cat['title']) ?></h5>
              <p><?= esc($cat['description']) ?></p>
              <button class="openFormBtn" data-category="<?= esc($cat['title']) ?>">
                <i class="bi bi-envelope-fill me-1"></i> Contact
              </button>
            </div>
          </div>
        <?php endforeach; ?>
      <?php endif; ?>
    </div>

    <!-- Mobile Slider (visible below md) -->
    <div id="categoryCarousel" class="carousel slide d-md-none" data-bs-ride="carousel">
      <div class="carousel-inner text-center">
        <?php
          $first = true;
          if (empty($cats)) {
            echo '<div class="carousel-item active"><div class="category-card mx-4"><h5>Coming Soon</h5><p>Categories will appear here once available.</p><button class="openFormBtn" data-category="General"><i class="bi bi-envelope-fill me-1"></i> Contact</button></div></div>';
          } else {
            foreach ($cats as $cat) {
              echo '<div class="carousel-item '.($first?'active':'').'">
                      <div class="category-card mx-4">
                        <h5>'.esc($cat['title']).'</h5>
                        <p>'.esc($cat['description']).'</p>
                        <button class="openFormBtn" data-category="'.esc($cat['title']).'">
                          <i class="bi bi-envelope-fill me-1"></i> Contact
                        </button>
                      </div>
                    </div>';
              $first = false;
            }
          }
        ?>
      </div>

      <!-- Controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#categoryCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Previous</span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#categoryCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Next</span>
      </button>
    </div>

  </div>
</section>

<!-- ================= CONTACT FORM SECTION ================= -->
<section class="contact-section py-5">
  <div class="container-xl contact-form" id="contactFormSection">
    <div class="text-center mb-5">
      <h2 class="greet-title">Send Us a Message</h2>
      <p class="text-muted">We’ll respond to your message as soon as possible, In sha Allah.</p>
    </div>

    <div class="row justify-content-center">
      <div class="col-md-8">
        <form class="p-4 rounded-3 shadow-sm bg-white" action="contact-submit.php" method="POST">
          <div class="row g-3">
            <input type="hidden" id="selectedCategory" name="category">

            <div class="col-md-6">
              <label for="firstName" class="form-label fw-semibold">First Name</label>
              <input type="text" class="form-control" id="firstName" name="firstName" placeholder="Enter your first name" required>
            </div>

            <div class="col-md-6">
              <label for="lastName" class="form-label fw-semibold">Last Name</label>
              <input type="text" class="form-control" id="lastName" name="lastName" placeholder="Enter your last name" required>
            </div>

            <div class="col-md-6">
              <label for="email" class="form-label fw-semibold">Email</label>
              <input type="email" class="form-control" id="email" name="email" placeholder="Enter your email" required>
            </div>

            <div class="col-md-6">
              <label for="phone" class="form-label fw-semibold">Phone Number</label>
              <input type="tel" class="form-control" id="phone" name="phone" placeholder="Enter your phone number">
            </div>

            <div class="col-md-6">
              <label for="subject" class="form-label fw-semibold">Subject</label>
              <input type="text" class="form-control" id="subject" name="subject" placeholder="Enter subject" required>
            </div>

            <div class="col-md-6">
              <label for="categoryDisplay" class="form-label fw-semibold">Category</label>
              <input type="text" id="categoryDisplay" class="form-control bg-light" readonly>
            </div>

            <div class="col-12">
              <label for="message" class="form-label fw-semibold">Message</label>
              <textarea id="message" name="message" class="form-control" rows="5" placeholder="Write your message here..." required></textarea>
            </div>

            <div class="col-12 text-center mt-3">
              <button type="submit" class="btn btn-success px-4 py-2 rounded-pill">
                <i class="bi bi-send me-2"></i> Send Message
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ================= MOSQUE LOCATIONS ================= -->
<section class="mosque-map py-5 text-white">
  <div class="container-xl">
    <h2 class="text-center fw-bold mb-5 greet-title text-white">Our Mosque Locations</h2>
    <div class="row g-4">
      <?php if (empty($locs)): ?>
        <div class="col-12 text-center text-white-50">Locations will appear here once available.</div>
      <?php else: ?>
        <?php foreach ($locs as $l): ?>
          <div class="col-md-4">
            <h5 class="text-warning"><?= esc($l['title']) ?></h5>
            <p><?= esc($l['address']) ?></p>
            <iframe src="https://www.google.com/maps?q=<?= esc($l['map_query']) ?>&output=embed"></iframe>
          </div>
        <?php endforeach; ?>
      <?php endif; ?>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<!-- ================= FOOTER ================= -->
<?php include 'footer.php'; ?>

<!-- ================= JS ================= -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  // Show contact form when a category is clicked
  const buttons = document.querySelectorAll(".openFormBtn");
  const formSection = document.getElementById("contactFormSection");
  const categoryField = document.getElementById("selectedCategory");
  const categoryDisplay = document.getElementById("categoryDisplay");

  buttons.forEach(btn => {
    btn.addEventListener("click", () => {
      const cat = btn.getAttribute("data-category");
      categoryField.value = cat;
      categoryDisplay.value = cat;
      formSection.style.display = "block";
      formSection.scrollIntoView({ behavior: "smooth" });
    });
  });
</script>

<!-- Fixed Donate Button (Mobile Only) -->
<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = window.scrollY > lastScrollY ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>

</body>
</html>
