<?php
require_once "admin_pannel/db.php";

$settings = $pdo->query("SELECT * FROM converts_page_settings WHERE id=1")->fetch();

$sections = $pdo->query("SELECT * FROM converts_sections ORDER BY position")->fetchAll();

$paraStmt = $pdo->query("SELECT * FROM converts_paragraphs ORDER BY position");
$paras = [];
foreach ($paraStmt as $p) {
    $paras[$p['section_id']][] = $p;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($settings['page_title']) ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="css/style.css" rel="stylesheet">
<link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- HEADER -->
<section class="page-header text-center text-white py-5"
         style="background:url('<?= $settings['bg_image'] ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($settings['page_title']) ?></h1>
    <p class="lead"><?= htmlspecialchars($settings['page_subtitle']) ?></p>
  </div>
</section>

<!-- CONTENT -->
<section class="about-section py-5">
<div class="container-xl">

<?php foreach ($sections as $s): ?>
  <div class="mb-5">

    <h3 class="greet-title greet-title-in text-white fw-bold mb-3">
      <?= htmlspecialchars($s['section_title']) ?>
    </h3>

    <?php if (!empty($paras[$s['id']])): ?>
      <?php foreach ($paras[$s['id']] as $p): ?>

        <?php if ($p['type'] == 'heading'): ?>
          <h4 class="text-white fw-bold"><?= htmlspecialchars($p['para_text']) ?></h4>

        <?php elseif ($p['type'] == 'paragraph'): ?>
          <p><?= $p['para_text'] ?></p>

        <?php elseif ($p['type'] == 'li'): ?>
          <ul><li class="text-white"><?= $p['para_text'] ?></li></ul>

        <?php elseif ($p['type'] == 'html'): ?>
          <?= $p['para_text'] ?>

        <?php endif; ?>

      <?php endforeach; ?>
    <?php endif; ?>

  </div>
<?php endforeach; ?>


</div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
