<?php
require_once "admin_pannel/db.php";

$settings = $pdo->query("SELECT * FROM financial_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$sections = $pdo->query("SELECT * FROM financial_sections ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

$paras_stmt = $pdo->query("SELECT * FROM financial_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($paras_stmt as $p) { $paras[$p['section_id']][] = $p; }

$limits = $pdo->query("SELECT * FROM financial_limits ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

function section_open($isLight = false) {
  echo $isLight ? '<section class="py-5 bg-light">' : '<section class="py-5">';
  echo '<div class="container-xl">';
}
function section_close() { echo '</div></section>'; }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Financial Assistance (Rizq relif) | IAOS Regina</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="page-header text-center text-white py-5" style="background:url('<?= htmlspecialchars($settings['bg_image'] ?? 'images/banner2.jpg') ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-3"><?= htmlspecialchars($settings['page_title'] ?? 'Financial Assistance (Rizq relif)') ?></h1>
    <?php if (!empty($settings['page_subtitle'])): ?>
      <p class="lead fst-italic"><?= htmlspecialchars($settings['page_subtitle']) ?></p>
    <?php endif; ?>
  </div>
</section>

<?php
foreach ($sections as $s) {
  $isLight = ($s['style'] === 'default');
  section_open($isLight);

  $headingClass = ($s['style'] === 'green')
    ? 'greet-title greet-title-in text-white'
    : 'greet-title greet-title-in';

  echo '<h3 class="'.$headingClass.'">'.htmlspecialchars($s['section_title']).'</h3><br>';

  $items = $paras[$s['id']] ?? [];
  $ul_open = false;
  $textClass = $isLight ? '' : ' text-white';
  $showLimits = (trim($s['section_title']) === 'Types of Financial Assistance Provided' && !empty($limits));

  foreach ($items as $p) {
    $type = $p['type'] ?? 'paragraph';

    if ($type === 'heading') {
      if ($ul_open) { echo '</ul>'; $ul_open = false; }
      echo '<h5 class="fw-bold'. $textClass .'">'. htmlspecialchars($p['para_text']) .'</h5>';
    }
    elseif ($type === 'li') {
      if (!$ul_open) {
        echo $isLight ? '<ul>' : '<ul class="text-white">';
        $ul_open = true;
      }
      echo '<li>'. htmlspecialchars($p['para_text']) .'</li>';
    }
    elseif ($type === 'html') {
      if ($ul_open) { echo '</ul>'; $ul_open = false; }
      echo $p['para_text'];
    }
    else {
      if ($ul_open) { echo '</ul>'; $ul_open = false; }
      echo '<p class="mb-3'. $textClass .'">'. htmlspecialchars($p['para_text']) .'</p>';
    }
  }
  if ($ul_open) echo '</ul>';

  if ($showLimits) {
    echo '<div class="table-responsive mt-3">';
    echo '<table class="table table-bordered table-striped bg-light text-dark align-middle">';
    echo '<thead class="table-success text-center"><tr><th>Type of Need</th><th>Maximum Funding Limit per Application</th></tr></thead><tbody>';
    foreach ($limits as $r) {
      echo '<tr><td>'. htmlspecialchars($r['need']) .'</td><td>'. htmlspecialchars($r['max_limit']) .'</td></tr>';
    }
    echo '</tbody></table></div>';
  }

  section_close();
}
?>

<!-- APPLY SECTION -->
<section class="py-5 bg-light">
  <div class="container-xl">

    <div class="text-center mt-4">
      <button class="btn btn-success px-5 py-2" data-bs-toggle="collapse" data-bs-target="#takafulForm">
        <i class="bi bi-clipboard-check me-1"></i> Apply for Assistance
      </button>
    </div>

    <!-- COLLAPSIBLE FORM -->
    <div class="collapse mt-5" id="takafulForm">
      <div class="card card-body shadow-sm border-0 mx-auto" style="max-width:900px;">

        <h4 class="mb-4 text-success">Financial Assistance (Takaful) Application Form</h4>
        <p>Please ensure to include required support documents, otherwise your application will be denied.</p>

        <form>
          <!-- Applicant Info -->
          <h5 class="mt-4">Applicant Information</h5>
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">First Name *</label><input type="text" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Last Name *</label><input type="text" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">SIN *</label><input type="text" class="form-control" placeholder="123-456-789" maxlength="11" required></div>
            <div class="col-md-6"><label class="form-label">Date of Birth *</label><input type="date" class="form-control" required></div>
            <div class="col-md-6">
              <label class="form-label">Legal Status *</label>
              <select class="form-select" required>
                <option>Citizen</option>
                <option>Permanent Resident</option>
                <option>Refugee</option>
                <option>Other</option>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">Marital Status *</label>
              <select class="form-select" required>
                <option>Single</option>
                <option>Married</option>
                <option>Divorced</option>
                <option>Widowed</option>
              </select>
            </div>
          </div>

          <!-- Personal Info -->
          <h5 class="mt-4">Personal Information</h5>
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">Phone *</label><input type="text" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Email *</label><input type="email" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Confirm Email *</label><input type="email" class="form-control" required></div>
            <div class="col-md-12"><label class="form-label">Home Address *</label><input type="text" class="form-control" required></div>
          </div>

          <!-- Employment -->
          <h5 class="mt-4">Employment Information</h5>
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">Name of Company *</label><input type="text" class="form-control"></div>
            <div class="col-md-6"><label class="form-label">Job Title *</label><input type="text" class="form-control"></div>
            <div class="col-md-12"><label class="form-label">Company Address *</label><input type="text" class="form-control"></div>
          </div>

          <!-- File Uploads -->
          <h5 class="mt-4">Supporting Documents</h5>
          <p>Please upload the following documents, if applicable.</p>
          <input type="file" class="form-control" multiple>

          <!-- Type of Need -->
          <h5 class="mt-4">Type of Need Requested (Select up to 3) *</h5>
          <div class="row g-2">
            <div class="col-md-2"><div class="form-check"><input class="form-check-input" type="checkbox"> <label>Rent</label></div></div>
            <div class="col-md-2"><div class="form-check"><input class="form-check-input" type="checkbox"> <label>Utilities</label></div></div>
            <div class="col-md-2"><div class="form-check"><input class="form-check-input" type="checkbox"> <label>Food</label></div></div>
            <div class="col-md-2"><div class="form-check"><input class="form-check-input" type="checkbox"> <label>Clothing</label></div></div>
            <div class="col-md-2"><div class="form-check"><input class="form-check-input" type="checkbox"> <label>Transportation</label></div></div>
            <div class="col-md-2"><div class="form-check"><input class="form-check-input" type="checkbox"> <label>Other</label></div></div>
          </div>

          <div class="mt-3">
            <label class="form-label">Other request and amount</label>
            <input type="text" class="form-control">
          </div>

          <!-- References -->
          <h5 class="mt-4">References</h5>
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">Reference 1 Name *</label><input type="text" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Reference 1 Phone *</label><input type="text" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Reference 2 Name</label><input type="text" class="form-control"></div>
            <div class="col-md-6"><label class="form-label">Reference 2 Phone</label><input type="text" class="form-control"></div>
          </div>

          <!-- Declaration -->
          <h5 class="mt-4">Applicant Declaration</h5>
          <p class="small">
            By submitting this application, I confirm that all information provided is true and accurate.
          </p>

          <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" required>
            <label class="form-check-label">I accept and testify to the above</label>
          </div>

          <div class="col-md-4 mb-3">
            <label class="form-label">Date</label>
            <input type="date" class="form-control" required>
          </div>

          <p class="text-muted small">Please do not follow-up with phone calls. You will be contacted after processing.</p>

          <div class="text-center mt-4">
            <button type="submit" class="btn btn-success px-5 py-2">Submit</button>
          </div>

        </form>

      </div>
    </div>

  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
