<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Fine Option / Community Services | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner2.jpg') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-3">Fine Option / Community Services</h1>
    <p class="lead fst-italic">“Helping build stronger communities through service and responsibility.”</p>
  </div>
</section>

<!-- ================= MAIN CONTENT ================= -->
<section class="py-5">
  <div class="container-xl">
    <h2 class="greet-title greet-title-in text-white">Fine Option Program</h2>
    <br>
    <p class="text-white mb-4">
      The <strong>Fine Option Program</strong> is not an alternative to sentencing but provides individuals an opportunity
      to settle fines by performing unpaid, supervised community service work instead of paying in cash.
    </p>

    <div class="bg-light text-dark p-4 rounded-3 shadow-sm mb-4">
      <p>
        Participants complete community service hours through the Fine Option Program. The Ministry of Justice collaborates with
        town councils, First Nations communities, local non-profit organizations, or individuals to administer the program under a
        contractual agreement.
      </p>

      <p>
        These organizations or individuals, known as <strong>Fine Option Agencies</strong>, assign suitable community
        service work to people who register to settle fines under the program. The agencies also notify the court
        of the outcome of each assignment.
      </p>
    </div>

    <div class="text-center mt-4">
      <a href="https://www.saskatchewan.ca/residents/justice-crime-and-the-law/courts-and-sentencing/alternatives-to-paying-a-provincial-fine" 
         target="_blank" 
         class="btn btn-outline-light px-5 py-2 mb-3">
         <i class="bi bi-link-45deg me-1"></i> Learn More at Saskatchewan.ca
      </a>
    </div>
  </div>
</section>

<!-- ================= COMMUNITY SERVICE ================= -->
<section class="py-5 bg-light">
  <div class="container-xl">
    <h3 class="greet-title greet-title-in">Community Service Opportunities</h3>
    <br>
    <p>
      The <strong>Islamic Association of Saskatchewan (IAOS-Regina)</strong> welcomes individuals who are registered under
      the Fine Option Program to contribute their time towards meaningful community service. 
      Participants may assist in mosque maintenance, events, and outreach initiatives — helping strengthen the sense of community.
    </p>
    <p>
      For more information or to register, please complete the form below.
    </p>

    <div class="text-center mt-4">
      <a href="https://fineoptions.ca/register/fine-option/" target="_blank"><button class="btn btn-success px-5 py-2">
        <i class="bi bi-clipboard-check me-1"></i> Register for Fine Option Program
      </button></a>
    </div>

    <!-- COLLAPSIBLE FINE OPTION FORM -->
    <div class="collapse mt-5" id="fineForm">
      <div class="card card-body shadow-sm border-0">
        <h4 class="text-success mb-4">Fine Option Program Registration Form</h4>
        <p>Before registering, review our Partner Agencies page to see the roles and requirements for volunteering at each agency.</p>

        <form>
          <!-- Applicant Info -->
          <h5 class="mt-3">Applicant Contact Information</h5>
          <div class="row g-3">
            <div class="col-md-6"><label class="form-label">First Name *</label><input type="text" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Last Name *</label><input type="text" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Email *</label><input type="email" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Confirm Email *</label><input type="email" class="form-control" required></div>
            <div class="col-md-6"><label class="form-label">Primary Phone *</label><input type="text" class="form-control" placeholder="(___) ___-____" required></div>
            <div class="col-md-6"><label class="form-label">Alternate Phone</label><input type="text" class="form-control" placeholder="(___) ___-____"></div>
            <div class="col-md-6"><label class="form-label">Date of Birth *</label><input type="date" class="form-control" required></div>
            <div class="col-md-12"><label class="form-label">Address *</label><input type="text" class="form-control" placeholder="Street, City, Postal Code" required></div>
          </div>

          <!-- Photo ID Upload -->
          <h5 class="mt-4">Upload Government-Issued Photo ID</h5>
          <input type="file" class="form-control" accept=".jpg,.jpeg,.png,.pdf" required>

          <!-- Court Info -->
          <h5 class="mt-4">Court Information</h5>
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Home Court Location *</label>
              <select class="form-select" required>
                <option selected disabled>Select...</option>
                <option>Regina</option>
                <option>Saskatoon</option>
                <option>Moose Jaw</option>
                <option>Prince Albert</option>
                <option>Other</option>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">Home Court *</label>
              <input type="text" class="form-control" required>
            </div>
            <div class="col-md-12">
              <label class="form-label">Court Date *</label>
              <input type="date" class="form-control" required>
            </div>
          </div>

          <!-- Applicant Details -->
          <h5 class="mt-4">Applicant Details</h5>
          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label">Gender</label>
              <select class="form-select">
                <option>Male</option><option>Female</option><option>Other</option>
              </select>
            </div>
            <div class="col-md-4">
              <label class="form-label">Ethnicity</label>
              <select class="form-select">
                <option>Metis</option><option>Status Native</option><option>Non-Status Native</option><option>Caucasian</option><option>Other</option>
              </select>
            </div>
            <div class="col-md-4">
              <label class="form-label">Employment Status</label>
              <select class="form-select">
                <option>Employed</option><option>Unemployed</option><option>Student</option><option>Homemaker</option><option>Disabled</option>
              </select>
            </div>
          </div>

          <div class="mt-3">
            <label class="form-label">Which city would you like to volunteer in? *</label>
            <select class="form-select" required>
              <option selected disabled>Select...</option>
              <option>Regina</option><option>Saskatoon</option><option>Moose Jaw</option><option>Prince Albert</option>
            </select>
          </div>

          <div class="mt-3">
            <label class="form-label">How did you hear about this program?</label>
            <input type="text" class="form-control" placeholder="e.g. Notice of Fine, Friend, Court Officer">
          </div>

          <!-- Upload Notice -->
          <h5 class="mt-4">Upload Notice of Fine *</h5>
          <input type="file" class="form-control" accept=".jpg,.jpeg,.png,.pdf" multiple required>

          <!-- List Infractions -->
          <h5 class="mt-4">List Infractions</h5>
          <p class="small">Enter each fine or surcharge below.</p>
          <div class="row g-3">
            <div class="col-md-3"><input type="text" class="form-control" placeholder="File/Ticket No."></div>
            <div class="col-md-3"><input type="text" class="form-control" placeholder="Act/CCC"></div>
            <div class="col-md-2"><input type="text" class="form-control" placeholder="Section"></div>
            <div class="col-md-2"><input type="text" class="form-control" placeholder="Fine $"></div>
            <div class="col-md-2"><input type="text" class="form-control" placeholder="Surcharge $"></div>
          </div>

          <!-- Totals -->
          <h5 class="mt-4">Fine Summary</h5>
          <div class="row g-3">
            <div class="col-md-3"><label class="form-label">Total Fines</label><input type="number" class="form-control" placeholder="$"></div>
            <div class="col-md-3"><label class="form-label">Minimum Wage</label><input type="number" class="form-control" placeholder="$15.00"></div>
            <div class="col-md-3"><label class="form-label">Cash Paid</label><input type="number" class="form-control" placeholder="$0.00"></div>
            <div class="col-md-3"><label class="form-label">Total Hours</label><input type="number" class="form-control" placeholder="0"></div>
          </div>

          <!-- Consents -->
          <h5 class="mt-4">Consents</h5>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" required>
            <label class="form-check-label">I understand and agree to the privacy policy.</label>
          </div>
          <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" required>
            <label class="form-check-label">I understand and agree to the work-based program consent.</label>
          </div>

          <div class="text-center mt-4">
            <button type="submit" class="btn btn-success px-5 py-2">Submit</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
