<?php
require_once "admin_pannel/db.php";

// Fetch all active menu items ordered by position
$stmt = $pdo->query("SELECT * FROM menu_items WHERE is_active = 1 ORDER BY position ASC");
$menus = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Group by parent_id for nested rendering
$menuTree = [];
foreach ($menus as $m) {
  $menuTree[$m['parent_id']][] = $m;
}

// Recursive menu renderer
function renderMenu($parentId, $menuTree) {
  if (empty($menuTree[$parentId])) return '';
  $html = '<ul class="dropdown-menu">';
  foreach ($menuTree[$parentId] as $item) {
    $hasSub = !empty($menuTree[$item['id']]);
    $html .= '<li>';
    $html .= '<a class="dropdown-item'.($hasSub ? ' dropdown-toggle' : '').'" href="'.$item['page_link'].'" '.($hasSub ? 'data-bs-toggle="dropdown"' : '').'>'.$item['title'].'</a>';
    if ($hasSub) {
      $html .= renderMenu($item['id'], $menuTree);
    }
    $html .= '</li>';
  }
  $html .= '</ul>';
  return $html;
}
?>

<!-- ================= NAVBAR ================= -->
<header class="site-header">
  <nav class="navbar navbar-expand-lg navbar-dark main-nav">
    <div class="container-xl">
      <a class="navbar-brand d-flex align-items-center" href="index.php">
        <img src="images/logo-white.png" alt="IAOS" class="logo me-2">
        <span class="brand-text"></span>
      </a>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="mainNav">
        <ul class="navbar-nav ms-auto align-items-lg-center gap-lg-3">
          <?php
          if (!empty($menuTree[NULL])) {
            foreach ($menuTree[NULL] as $mainItem) {
              $hasSub = !empty($menuTree[$mainItem['id']]);
              echo '<li class="nav-item '.($hasSub ? 'dropdown' : '').'">';
              echo '<a class="nav-link '.($hasSub ? 'dropdown-toggle' : '').'" href="'.$mainItem['page_link'].'" '.($hasSub ? 'data-bs-toggle="dropdown"' : '').'>'.$mainItem['title'].'</a>';
              if ($hasSub) echo renderMenu($mainItem['id'], $menuTree);
              echo '</li>';
            }
          }
          ?>

          <!-- Member & Donate Buttons -->
          <li class="nav-item">
            <a href="#" class="nav-link p-0 ms-lg-2">
              <img src="images/btn_member.png" alt="Member" class="nav-btn-img">
            </a>
          </li>
          <li class="nav-item">
            <a href="https://www.paypal.com/donate/?hosted_button_id=YMRQ7WG4XNNHC" class="nav-link p-0 ms-lg-2">
              <img src="images/btn_donation.png" alt="Donate" class="nav-btn-img">
            </a>
          </li>

        </ul>
      </div>
    </div>
  </nav>
</header>
