<?php
require_once "admin_pannel/db.php";

$settings = $pdo->query("SELECT * FROM marriage_page_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$sections = $pdo->query("SELECT * FROM marriage_sections ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

$paras_stmt = $pdo->query("SELECT * FROM marriage_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($paras_stmt as $p) { 
    $paras[$p['section_id']][] = $p; 
}

$officials = $pdo->query("SELECT * FROM marriage_officials ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// Helper
function section_open($isLight = false) {
    echo $isLight ? '<section class="py-5 bg-light">' : '<section class="py-5">';
    echo '<div class="container-xl">';
}
function section_close() {
    echo '</div></section>';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Marriage & Nikkah | IAOS Regina</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">

  <link rel="icon" type="image/png" href="images/fav.png">
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
    
    <!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- ================= PAGE HEADER ================= -->
<section class="page-header text-center text-white py-5" 
style="background:url('<?= htmlspecialchars($settings['bg_image'] ?? 'images/banner2.jpg') ?>') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-3"><?= htmlspecialchars($settings['page_title'] ?? 'Marriage & Nikkah') ?></h1>
    <?php if (!empty($settings['page_subtitle'])): ?>
      <p class="lead fst-italic"><?= htmlspecialchars($settings['page_subtitle']) ?></p>
    <?php endif; ?>
  </div>
</section>

<?php
foreach ($sections as $s):

    $isLight = ($s['style'] === 'default'); // default = white background
    section_open($isLight);

    // ✅ Heading coloring
    $headingClass = ($s['style'] === 'green')
        ? 'greet-title greet-title-in text-white'
        : 'greet-title greet-title-in';

    echo '<h3 class="'.$headingClass.'">'.htmlspecialchars($s['section_title']).'</h3><br>';

    /* ===================== OFFICIALS BLOCK ===================== */
    if ($s['section_title'] === 'Officials Registered to Perform Marriages') {

        echo '<div class="row g-4">';
        foreach ($officials as $o) {
            echo '<div class="col-md-4">';
            echo '  <div class="p-4 border rounded-3 shadow-sm h-100">';
            echo '    <h5 class="fw-bold text-success mb-1">'.htmlspecialchars($o['name']).'</h5>';
            if (!empty($o['phone'])) {
                echo '    <p class="mb-0"><strong>'.htmlspecialchars($o['phone']).'</strong></p>';
            }
            echo '  </div>';
            echo '</div>';
        }
        echo '</div>';

        echo '<div class="text-center mt-4">';
        echo '<p>Please contact the IAOS to setup an appointment: ';
        echo '<a href="contact.php" class="fw-bold text-success">Click here</a></p></div>';

        section_close();
        continue;
    }

    /* ===================== PARAGRAPHS / LISTS ===================== */
    $items = $paras[$s['id']] ?? [];
    $ul_open = false;

    // Highlight-box sections
    $useHighlight = in_array($s['section_title'], [
        'Getting Married under IAOS Regina',
        'Nikkah Bookings'
    ]);

    if ($useHighlight) {
        echo '<div class="highlight-box p-4 rounded-3 shadow-sm">';
    }

    foreach ($items as $p) {
        $type = $p['type'] ?? 'paragraph';

        // ✅ white text for green sections, black text for default
        $textColor = $isLight ? 'text-dark' : 'text-white';

        // LIST ITEM
        if ($type === 'li') {
            if (!$ul_open) {
                echo '<ul class="'.$textColor.'">';
                $ul_open = true;
            }
            echo '<li class="'.$textColor.'">'.htmlspecialchars($p['para_text']).'</li>';
            continue;
        }

        // RAW HTML BLOCK
        if ($type === 'html') {
            echo '<div class="'.$textColor.'">'.$p['para_text'].'</div>';
            continue;
        }

        // NORMAL PARAGRAPH
        echo '<p class="mb-3 '.$textColor.'">'.htmlspecialchars($p['para_text']).'</p>';
    }

    if ($ul_open) echo '</ul>';
    if ($useHighlight) echo '</div>';

    section_close();
endforeach;
?>

<!-- ================= BOOKING FORM ================= -->
<section class="py-5 bg-light">
  <div class="container-xl">
    <h3 class="greet-title greet-title-in">Enter Details</h3>
    <br>
    <form class="p-4 bg-white rounded-3 shadow-sm">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">First Name *</label>
          <input type="text" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Last Name *</label>
          <input type="text" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Email *</label>
          <input type="email" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Phone Number *</label>
          <input type="text" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Full Name Groom (Male) *</label>
          <input type="text" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Full Name of Bride (Female) *</label>
          <input type="text" class="form-control" required>
        </div>
        <div class="col-12">
          <label class="form-label">This booking does NOT include an imam. Confirm imam availability prior to booking. *</label>
          <p class="fw-bold text-success">$700</p>
        </div>

        <div class="col-12">
          <label class="form-label">Expected number of guests *</label>
          <select class="form-select" required>
            <option>1–50</option>
            <option>51–150</option>
            <option>151–250</option>
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Seating Format *</label>
          <select class="form-select" required>
            <option>Men on one side – Women on the other side (facing forward)</option>
            <option>Men in the front – Women in the back</option>
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Dress Code *</label>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" required>
            <label class="form-check-label">I agree to ensure all my guests will dress modestly as per masjid guidelines.</label>
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Name of Imam officiating *</label>
          <input type="text" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Imam Phone *</label>
          <input type="text" class="form-control" required>
        </div>

        <div class="col-12">
          <label class="form-label">Payment Information *</label>
          <p><strong>Price:</strong> $700 CAD</p>
          <p>
            <strong>Payment Terms & Cancellation Policy:</strong><br>
            You may cancel 30 days before the booking for a full refund minus $100 administration fee.<br>
            50% refund if canceled 15–30 days before. No refunds within 14 days.<br>
            Date changes must be made at least 15 days before, with a $100 change fee.<br>
            To cancel or change, email: <a href="mailto:bookings@IAOS-Regina.com">bookings@IAOS-Regina.com</a>.
          </p>
        </div>
      </div>

      <div class="text-center mt-4">
        <button type="submit" class="btn btn-success px-5 py-2">Pay & Confirm Booking</button>
      </div>
    </form>
  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
