<?php
session_start();

/* -----------------------------------------
   PAYPAL CONFIG
------------------------------------------ */
$PAYPAL_MODE = "live"; // "sandbox" OR "live"
$PAYPAL_CLIENT_ID = "AV_riSlunWTn1mKi6Xen1m2R-EvAxb55Wni-3nNThnyyPMMah9qd5dgEE6CHvalVcrcLxR6w1oa9ReJA";
$PAYPAL_SECRET_ID = "EBhrsEZ1dT4YbS5i6xVhVJU8ws5bHqlFCnl0A43AZcsS5ZoAOdYSajLRn5GzVTFQ3_uoFOXt7rhaes8_";
$PAY_CURRENCY = "CAD";
$MEMBERSHIP_FEE = 10.00;
$baseUrl = ($PAYPAL_MODE === "live") ? "https://api-m.paypal.com" : "https://api-m.sandbox.paypal.com";

/* -----------------------------------------
   Handle AJAX form save
------------------------------------------ */
if($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"])){

    header("Content-Type: application/json");

    if($_POST["action"] === "save_member"){
        // Optional pre-payment save
        $firstName = trim($_POST["first_name"] ?? "");
        $lastName  = trim($_POST["last_name"] ?? "");
        $email     = trim($_POST["email"] ?? "");
        $address   = trim($_POST["address"] ?? "");

        if(!$firstName || !$lastName || !filter_var($email, FILTER_VALIDATE_EMAIL) || !$address){
            echo json_encode(["status"=>"error","message"=>"Please fill all required fields correctly"]);
            exit;
        }

        // You can save to DB here if needed

        echo json_encode(["status"=>"success","message"=>"Form validated. Please complete your payment"]);
        exit;
    }

    if($_POST["action"] === "save_member_after_payment"){
        $firstName = trim($_POST["first_name"] ?? "");
        $lastName  = trim($_POST["last_name"] ?? "");
        $email     = trim($_POST["email"] ?? "");
        $address   = trim($_POST["address"] ?? "");
        $subscriptionID = $_POST["subscriptionID"] ?? "";

        if(!$firstName || !$lastName || !$email || !$address || !$subscriptionID){
            echo json_encode(["status"=>"error","message"=>"Incomplete data for membership"]);
            exit;
        }

        // Save successful payment to DB
        // Example: INSERT INTO members (first_name,last_name,email,address,subscription_id,created_at) VALUES (?,?,?,?,?,NOW())

        echo json_encode(["status"=>"success","message"=>"Membership activated successfully"]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Membership | IAOS Regina</title>

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

<link rel="icon" type="image/png" href="images/fav.png">
<link rel="stylesheet" href="css/style.css">

<style>
.membership-card { background: #f8f9fa; border-radius: 12px; padding: 25px; text-align: center; transition: all 0.3s ease; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
.membership-card h5 { font-weight: 700; color: #0f5132; }
.download-btn { background-color: #0f5132; color: #fff; border-radius: 50px; padding: 10px 25px; border: none; transition: 0.3s; }
.download-btn:hover { background-color: #198754; color: #fff; }

#resultBox { margin-top:15px; padding:12px; border-radius:10px; font-size:14px; line-height:1.5; display:none; }
.successBox { background:#d1f7d6;color:#0f5132; }
.errorBox { background:#f8d7da;color:#842029; }
</style>
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<!-- Navbar -->
<?php include 'header.php'; ?>

<!-- Page Header -->
<section class="page-header text-center text-white py-5" style="background:url('images/banner4.jpg') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Become a Monthly Member of IAOS</h1>
    <p class="lead">Support your community — join IAOS and enjoy exclusive benefits while supporting Allah's cause.</p>
  </div>
</section>

<!-- Intro -->
<section class="py-5 bg-dark text-white">
  <div class="container-xl">
    <h3 class="fw-bold mb-3">Monthly Membership Benefits</h3>
    <p>Become a <strong>monthly member for $<?= number_format($MEMBERSHIP_FEE,2) ?>/month</strong> and enjoy exclusive benefits while supporting IAOS Regina:</p>
    <ul>
      <li>Discounts at select local businesses supporting IAOS.</li>
      <li>Discounts on mosque facilities bookings and selected events.</li>
      <li>Show your membership card or number to claim these discounts.</li>
    </ul>
    <p><strong>Note:</strong> Only paid monthly members are eligible for these offers. Monthly members <strong>do not have voting rights</strong>.</p>
  </div>
</section>

<!-- Membership Form & PayPal -->
<section class="py-5 bg-light">
  <div class="container-xl">
    <div class="text-center mb-5">
      <h2 class="greet-title">Monthly Membership Application Form</h2>
      <p class="text-muted">In the Name of Allah, Most Gracious, Most Merciful</p>
      <p><strong>The Islamic Association of Saskatchewan, Regina Inc.</strong><br>3273 Montague Street, Regina, SK, S4S 1Z8<br>
      Phone: (306) 585-0090 | E-mail: iaos@iaosregina.com</p>
    </div>

    <div class="row justify-content-center">
      <div class="col-md-10">
        <form id="membershipForm" class="p-4 rounded-3 shadow-sm bg-white">
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label fw-semibold">First Name</label>
              <input type="text" class="form-control" name="first_name" id="firstName" required>
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Last Name</label>
              <input type="text" class="form-control" name="last_name" id="lastName" required>
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Address</label>
              <input type="text" class="form-control" name="address" id="address" placeholder="Street, City, Province, Postal Code" required>
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Email</label>
              <input type="email" class="form-control" name="email" id="email" required>
            </div>

            <div class="col-12 mt-3">
              <label class="form-label fw-semibold">Monthly Membership Fee ($<?= number_format($MEMBERSHIP_FEE,2) ?>)</label>
              <input type="number" class="form-control" name="monthly_fee" value="<?= $MEMBERSHIP_FEE ?>" readonly>
            </div>

            <div class="col-12 mt-3">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="declaration" id="declaration" required>
                <label class="form-check-label">
                  I agree to abide by IAOS regulations. I understand that monthly members <strong>do not have voting rights</strong>.
                </label>
              </div>
            </div>

            <div class="col-12 mt-4">
              <div id="paypal-button-container"></div>
              <div id="resultBox"></div>
            </div>

          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<?php include "prayer_modal.php"; ?>
<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://www.paypal.com/sdk/js?client-id=<?= htmlspecialchars($PAYPAL_CLIENT_ID) ?>&currency=<?= htmlspecialchars($PAY_CURRENCY) ?>"></script>

<script>
const resultBox = document.getElementById("resultBox");

paypal.Buttons({
    style: { layout: 'vertical', color: 'gold', shape: 'pill', label: 'subscribe' },
    onInit: function(data, actions) {
        actions.disable(); // disable until form is valid

        document.getElementById("membershipForm").addEventListener("input", () => {
            const firstName = document.getElementById("firstName").value.trim();
            const lastName  = document.getElementById("lastName").value.trim();
            const email     = document.getElementById("email").value.trim();
            const address   = document.getElementById("address").value.trim();
            const declaration = document.getElementById("declaration").checked;

            if(firstName && lastName && email && address && declaration){
                actions.enable();
            } else {
                actions.disable();
            }
        });
    },
    createSubscription: function(data, actions){
        return actions.subscription.create({
            'plan_id': 'P-XXXXXXXXXXXX' // Replace with your PayPal monthly plan ID
        });
    },
    onApprove: function(data){
        const firstName = document.getElementById("firstName").value.trim();
        const lastName  = document.getElementById("lastName").value.trim();
        const email     = document.getElementById("email").value.trim();
        const address   = document.getElementById("address").value.trim();

        fetch("membership.php", {
            method: "POST",
            headers: {"Content-Type":"application/x-www-form-urlencoded"},
            body: `action=save_member_after_payment&first_name=${encodeURIComponent(firstName)}&last_name=${encodeURIComponent(lastName)}&email=${encodeURIComponent(email)}&address=${encodeURIComponent(address)}&subscriptionID=${data.subscriptionID}`
        })
        .then(res=>res.json())
        .then(resp=>{
            if(resp.status === "success"){
                resultBox.style.display = "block";
                resultBox.className = "successBox";
                resultBox.innerHTML = "✅ Membership activated successfully!";
            } else {
                resultBox.style.display = "block";
                resultBox.className = "errorBox";
                resultBox.innerHTML = "❌ Error: "+resp.message;
            }
        })
        .catch(err=>{
            resultBox.style.display = "block";
            resultBox.className = "errorBox";
            resultBox.innerHTML = "❌ Error: "+err;
            console.error(err);
        });
    },
    onCancel: function(){
        resultBox.style.display = "block";
        resultBox.className = "errorBox";
        resultBox.innerHTML = "⚠️ Payment cancelled.";
    },
    onError: function(err){
        resultBox.style.display = "block";
        resultBox.className = "errorBox";
        resultBox.innerHTML = "❌ PayPal Error: "+err;
        console.error(err);
    }
}).render('#paypal-button-container');
</script>
</body>
</html>
