<?php
session_start();

/* ---------------- PAYPAL CONFIG ---------------- */
$PAYPAL_MODE = "live"; // "sandbox" OR "live"
$PAYPAL_CLIENT_ID = "YOUR_PAYPAL_CLIENT_ID";
$PAYPAL_SECRET_ID = "YOUR_PAYPAL_SECRET_ID";
$PAY_CURRENCY = "CAD";
$MEMBERSHIP_FEE_MONTHLY_INDIVIDUAL = 20.00;
$MEMBERSHIP_FEE_MONTHLY_COUPLE = 40.00;
$MEMBERSHIP_FEE_ANNUAL_INDIVIDUAL = 240.00;
$MEMBERSHIP_FEE_ANNUAL_COUPLE = 480.00;

/* Optional: Server-side AJAX save for membership form */
if($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"]) && $_POST["action"] === "save_voting_member"){
    header("Content-Type: application/json");

    $required_fields = [
        "first_name","last_name","email","address","city","province","postal_code",
        "declaration_muslim","declaration_resident","declaration_saskatchewan",
        "declaration_constitution","declaration_other_membership","agree"
    ];

    foreach($required_fields as $f){
        if(empty($_POST[$f])){
            echo json_encode(["status"=>"error","message"=>"Please fill all required fields. Missing: $f"]);
            exit;
        }
    }

    // Save data to DB here if needed
    // Example: INSERT INTO voting_members (...)

    echo json_encode(["status"=>"success","message"=>"Form submitted successfully! You will be able to pay after admin approval."]);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Voting Membership | IAOS Regina</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="css/style.css">

  <style>
    .membership-form-container { max-width: 900px; margin: auto; }
    #paymentArea { display: none; margin-top: 30px; }
    #resultBox { margin-top: 15px; padding: 12px; border-radius: 10px; font-size: 14px; line-height: 1.5; display: none; }
    .successBox { background:#d1f7d6;color:#0f5132; }
    .errorBox { background:#f8d7da;color:#842029; }
  </style>
</head>
<body>

<?php include 'header.php'; ?>

<section class="page-header text-center text-white py-5" style="background:url('images/banner4.jpg') center/cover no-repeat;">
  <div class="overlay"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2">Voting Membership Application</h1>
    <p class="lead">Apply online and pay after admin approval via EFT or PayPal.</p>
  </div>
</section>

<section class="py-5 bg-light">
  <div class="container membership-form-container">

    <!-- Form -->
    <form id="votingMembershipForm" class="p-4 rounded-3 shadow-sm bg-white">
      <h2 class="mb-4">Voting Membership Form</h2>

      <div class="row g-3">
        <!-- Member Info -->
        <div class="col-md-6">
          <label class="form-label fw-semibold">First Name</label>
          <input type="text" class="form-control" name="first_name" required>
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Last Name</label>
          <input type="text" class="form-control" name="last_name" required>
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Email</label>
          <input type="email" class="form-control" name="email" required>
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Phone</label>
          <input type="text" class="form-control" name="phone">
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Current Address</label>
          <input type="text" class="form-control" name="address" required>
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">City</label>
          <input type="text" class="form-control" name="city" required>
        </div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Province</label>
          <input type="text" class="form-control" name="province" required>
        </div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Postal Code</label>
          <input type="text" class="form-control" name="postal_code" required>
        </div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Current Profession</label>
          <input type="text" class="form-control" name="profession">
        </div>

        <!-- Spouse Info -->
        <div class="col-12 mt-3"><h4>Spouse Information (if applying for Family Membership)</h4></div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">First Name</label>
          <input type="text" class="form-control" name="spouse_first_name">
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Last Name</label>
          <input type="text" class="form-control" name="spouse_last_name">
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Email</label>
          <input type="email" class="form-control" name="spouse_email">
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Phone</label>
          <input type="text" class="form-control" name="spouse_phone">
        </div>
        <div class="col-md-6">
          <label class="form-label fw-semibold">Current Profession</label>
          <input type="text" class="form-control" name="spouse_profession">
        </div>

        <!-- References -->
        <div class="col-12 mt-3"><h4>References (Please provide two)</h4></div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Reference 1 Name</label>
          <input type="text" class="form-control" name="reference1_name" required>
        </div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Reference 1 Email</label>
          <input type="email" class="form-control" name="reference1_email" required>
        </div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Reference 1 Phone</label>
          <input type="text" class="form-control" name="reference1_phone" required>
        </div>

        <div class="col-md-4">
          <label class="form-label fw-semibold">Reference 2 Name</label>
          <input type="text" class="form-control" name="reference2_name" required>
        </div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Reference 2 Email</label>
          <input type="email" class="form-control" name="reference2_email" required>
        </div>
        <div class="col-md-4">
          <label class="form-label fw-semibold">Reference 2 Phone</label>
          <input type="text" class="form-control" name="reference2_phone" required>
        </div>

        <!-- Membership Fees -->
        <div class="col-12 mt-3">
          <h4>Membership Fee</h4>
          <p><strong>Monthly:</strong> $20 Individual / $40 Couple</p>
          <p><strong>Annual:</strong> $240 Individual / $480 Couple</p>
        </div>

        <!-- Declarations -->
        <div class="col-12 mt-3"><h4>Declarations (circle appropriate response)</h4>
          <div class="mb-2">I am a Muslim over the age of 18:
            <input type="radio" name="declaration_muslim" value="Yes" required> Yes
            <input type="radio" name="declaration_muslim" value="No"> No
          </div>
          <div class="mb-2">I am Permanent Resident OR Citizen of Canada:
            <input type="radio" name="declaration_resident" value="Yes" required> Yes
            <input type="radio" name="declaration_resident" value="No"> No
          </div>
          <div class="mb-2">I am living in Saskatchewan for at least six months:
            <input type="radio" name="declaration_saskatchewan" value="Yes" required> Yes
            <input type="radio" name="declaration_saskatchewan" value="No"> No
          </div>
          <div class="mb-2">I will abide by the constitution and By-Laws of IAOS Regina Inc.:
            <input type="radio" name="declaration_constitution" value="Yes" required> Yes
            <input type="radio" name="declaration_constitution" value="No"> No
          </div>
          <div class="mb-2">I am not a member of any other Islamic Organization in Saskatchewan:
            <input type="radio" name="declaration_other_membership" value="Yes" required> Yes
            <input type="radio" name="declaration_other_membership" value="No"> No
          </div>
          <p class="small text-muted mt-2">
            Terms & Conditions: Please do not pay any fee at the time of form submission. Fee will be collected only after approval from the administration based on verification. Payment is accepted only through EFT (Electronic Fund Transfer). You are required to provide a copy of your void cheque and 2 references. The admin will contact you upon approval.
          </p>
        </div>

        <!-- Agreement -->
        <div class="col-12 mt-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="agree" required>
            <label class="form-check-label">I agree to abide by IAOS Constitution & Bylaws.</label>
          </div>
        </div>

        <!-- Submit Button -->
        <div class="col-12 text-center mt-4">
          <button type="button" id="submitFormBtn" class="btn btn-success px-4 py-2 rounded-pill">
            <i class="bi bi-send me-1"></i> Submit Form
          </button>
        </div>

      </div>
    </form>

    <!-- Payment Area (hidden until admin approval) -->
    <div id="paymentArea">
      <h3 class="mt-5">Payment Section (After Approval)</h3>
      <div id="paypal-button-container"></div>
      <div id="resultBox"></div>
    </div>

  </div>
</section>

<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://www.paypal.com/sdk/js?client-id=<?= $PAYPAL_CLIENT_ID ?>&currency=<?= $PAY_CURRENCY ?>"></script>

<script>
const submitBtn = document.getElementById("submitFormBtn");
const resultBox = document.getElementById("resultBox");
const paymentArea = document.getElementById("paymentArea");

submitBtn.addEventListener("click", ()=>{
    const form = document.getElementById("votingMembershipForm");
    const formData = new FormData(form);
    formData.append("action","save_voting_member");

    fetch("<?php echo $_SERVER['PHP_SELF']; ?>",{
        method:"POST",
        body: formData
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.status === "success"){
            alert(data.message);
            paymentArea.style.display = "block";
            submitBtn.style.display = "none";

            // Render PayPal button after approval
            paypal.Buttons({
                style:{layout:'vertical',color:'gold',shape:'pill',label:'subscribe'},
                createSubscription:function(data,actions){
                    return actions.subscription.create({
                        plan_id:'P-XXXXXXXXXXXX' // Replace with your PayPal monthly plan ID
                    });
                },
                onApprove:function(data){
                    resultBox.style.display="block";
                    resultBox.className="successBox";
                    resultBox.innerHTML=`<b>✅ Payment Successful!</b><br>Subscription ID: ${data.subscriptionID}<br>Thank you!`;
                },
                onCancel:function(){ resultBox.style.display="block"; resultBox.className="errorBox"; resultBox.innerHTML="⚠️ Payment cancelled."; },
                onError:function(err){ resultBox.style.display="block"; resultBox.className="errorBox"; resultBox.innerHTML="❌ PayPal Error: "+err; console.error(err); }
            }).render("#paypal-button-container");

        } else {
            alert(data.message);
        }
    })
    .catch(err=>{ alert("Error: "+err); console.error(err); });
});
</script>

</body>
</html>
