<?php
require_once "admin_pannel/db.php";

// Settings + About content
$set = $pdo->query("SELECT * FROM iaos_policies_settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$aboutHeading = $set['about_heading'] ?? 'About Our Policies';
$aboutParas = $pdo->query("SELECT * FROM iaos_policies_about_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);

// Headings + Paragraphs
$heads = $pdo->query("SELECT * FROM iaos_policies_headings ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$pp = $pdo->query("SELECT * FROM iaos_policies_paragraphs ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
$paras = [];
foreach ($pp as $row) { $paras[$row['heading_id']][] = $row; }

// Files
$files = $pdo->query("SELECT * FROM iaos_policies_files ORDER BY position ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Policies | IAOS Regina</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <link rel="stylesheet" href="css/style.css">
  <link rel="icon" type="image/png" href="images/fav.png">
</head>
<body>

<!-- Floating Prayer Button -->
<div class="prayer-btn">
  <img src="images/btn_prayer.png" alt="Prayer Times" data-bs-toggle="modal" data-bs-target="#prayerModal">
</div>

<?php include 'header.php'; ?>

<!-- PAGE HEADER -->
<section class="page-header text-center text-white py-5" style="background:url('<?= htmlspecialchars('uploads/'.$set['bg_image'] ?: 'images/banner4.jpg') ?>') center/cover no-repeat;">
  <div class="overlay position-absolute top-0 start-0 w-100 h-100"></div>
  <div class="container position-relative">
    <h1 class="display-4 fw-bold mb-2"><?= htmlspecialchars($set['page_title'] ?: 'IAOS Policies') ?></h1>
    <p class="lead"><?= htmlspecialchars($set['page_subtitle'] ?: 'Guiding documents and frameworks for IAOS operations and governance') ?></p>
  </div>
</section>

<!-- ABOUT / INTRO -->
<section class="py-5">
  <div class="container-xl">
    <div class="mb-5">
      <h3 class="greet-title fw-bold mb-3 greet-title-in text-white"><?= htmlspecialchars($aboutHeading) ?></h3>
      <?php foreach ($aboutParas as $ap): ?>
        <p class="lead"><?= nl2br(htmlspecialchars($ap['para_text'])) ?></p>
      <?php endforeach; ?>
    </div>

    <!-- DOWNLOADS -->
    <div class="policy-box">
      <div class="row gy-3">
        <?php foreach ($files as $f): ?>
          <div class="col-md-6">
            <a href="uploads/policies/<?= htmlspecialchars($f['file_name']) ?>" class="btn-policy" download>
              <?= htmlspecialchars($f['file_title']) ?>
              <i class="bi bi-file-earmark-arrow-down"></i>
            </a>
          </div>
        <?php endforeach; ?>
      </div>
    </div>

    <!-- HEADINGS + PARAGRAPHS -->
    <div class="mt-5">
      <?php foreach ($heads as $h): ?>
        <h4 class="text-white mt-4 mb-2"><?= htmlspecialchars($h['heading_text']) ?></h4>
        <?php if (!empty($paras[$h['id']])): ?>
          <?php foreach ($paras[$h['id']] as $p): ?>
            <p><?= nl2br(htmlspecialchars($p['para_text'])) ?></p>
          <?php endforeach; ?>
        <?php endif; ?>
      <?php endforeach; ?>
    </div>

  </div>
</section>

<!-- ✅✅✅ Prayer Modal (FIXED) -->
<?php include "prayer_modal.php"; ?>


<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<a href="#donate" class="mobile-donate-btn">Donate Now</a>
<script>
let lastScrollY = window.scrollY;
const donateBtn = document.querySelector('.mobile-donate-btn');
window.addEventListener('scroll', () => {
  donateBtn.style.opacity = (window.scrollY > lastScrollY) ? '0' : '1';
  lastScrollY = window.scrollY;
});
</script>
</body>
</html>
